/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange;

import com.atlassian.bitbucket.repository.AbstractRefCallback;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefContext;
import com.atlassian.bitbucket.repository.RefSummary;
import com.atlassian.bitbucket.repository.Tag;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class RefFileOutCallback
extends AbstractRefCallback {
    private final Path path;
    private int added;
    private WritableByteChannel channel;

    public RefFileOutCallback(Path path) {
        this.path = path;
    }

    public void onEnd(@Nonnull RefSummary summary) throws IOException {
        WritableByteChannel channel = this.channel;
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close output channel", e);
            }
            this.channel = null;
        }
    }

    public boolean onRef(@Nonnull Ref ref) {
        try {
            ByteBuffer refOut = this.writeRefToBuffer(ref);
            if (refOut.hasRemaining()) {
                this.channel.write(refOut);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to copy from stdout to output channel", e);
        }
        return true;
    }

    public void onStart(@Nonnull RefContext context) throws IOException {
        this.channel = Files.newByteChannel(this.path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        this.added = 0;
    }

    private ByteBuffer writeRefToBuffer(Ref ref) {
        String hash = null;
        if (ref instanceof Tag) {
            hash = ((Tag)ref).getHash();
        }
        if (hash == null) {
            hash = ref.getLatestCommit();
        }
        StringBuilder builder = new StringBuilder();
        if (this.added++ > 0) {
            builder.append("\n");
        }
        builder.append(hash);
        builder.append('\t');
        builder.append(ref.getId());
        byte[] bytes = builder.toString().getBytes(StandardCharsets.UTF_8);
        return ByteBuffer.wrap(bytes);
    }
}

