/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.MirrorRefHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.MirrorFarmRefChange;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeIterator;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.google.common.io.Closer;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRefChangeIterator
implements RefChangeIterator {
    private static final Logger log = LoggerFactory.getLogger(SimpleRefChangeIterator.class);
    private final RefChangeType changeType;
    private final Closer closer;
    private final Iterator<String> refs;

    public SimpleRefChangeIterator(@Nonnull Iterator<String> iterator, @Nonnull RefChangeType changeType, @Nonnull Closer closer) {
        this.refs = Objects.requireNonNull(iterator, "iterator");
        this.changeType = Objects.requireNonNull(changeType, "changeType");
        this.closer = Objects.requireNonNull(closer, "closer");
    }

    @Override
    public void close() {
        try {
            this.closer.close();
        }
        catch (Exception e) {
            log.debug("Error while closing readers", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.refs.hasNext();
    }

    @Override
    public MirrorFarmRefChange next() {
        return MirrorRefHelper.toRefChange(this.refs.next(), this.changeType);
    }
}

