/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.exception.MirrorOperationErrorException;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.metrics.JmxHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RequestStatus;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeCalculator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeIterator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangePublisher;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositoryIncrementalSyncEventVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySnapshotSyncEventVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.SynchronizationMetricHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ResultVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.DefaultRepositoryLockCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryLockService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.DefaultBranchUpdateRequest;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FarmOrchestrator {
    private static final Logger log = LoggerFactory.getLogger(FarmOrchestrator.class);
    private final ClusterService clusterService;
    private final EventPublisher eventPublisher;
    private final MirrorRepositoryLockService mirrorRepositoryLockService;
    private final MirrorRepositoryService mirrorRepositoryService;
    private final RefChangeCalculator refChangeCalculator;
    private final RefChangePublisher refChangePublisher;
    private final RequestReplyTopic<DefaultBranchUpdateRequest, Boolean> repositoryDefaultBranchUpdateTopic;
    private final Topic<String> repositoryLockReleaseTopic;
    private final SynchronizationMetricHelper synchronizationMetricHelper;
    private final Path tempDir;
    private final RequestReplyTopic<RepositorySynchronizationRequest, RepositorySynchronizationResponse> updateRefTopic;

    @Autowired
    public FarmOrchestrator(ClusterService clusterService, EventPublisher eventPublisher, RefChangeCalculator refChangeCalculator, MirrorRepositoryLockService mirrorRepositoryLockService, MirrorRepositoryService mirrorRepositoryService, RequestReplyTopic<DefaultBranchUpdateRequest, Boolean> repositoryDefaultBranchUpdateTopic, RefChangePublisher refChangePublisher, Topic<String> repositoryLockReleaseTopic, StorageService storageService, SynchronizationMetricHelper synchronizationMetricHelper, RequestReplyTopic<RepositorySynchronizationRequest, RepositorySynchronizationResponse> updateRefTopic) {
        this.clusterService = clusterService;
        this.eventPublisher = eventPublisher;
        this.mirrorRepositoryLockService = mirrorRepositoryLockService;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.repositoryDefaultBranchUpdateTopic = repositoryDefaultBranchUpdateTopic;
        this.updateRefTopic = updateRefTopic;
        this.refChangeCalculator = refChangeCalculator;
        this.refChangePublisher = refChangePublisher;
        this.repositoryLockReleaseTopic = repositoryLockReleaseTopic;
        this.synchronizationMetricHelper = synchronizationMetricHelper;
        this.tempDir = storageService.getTempDir();
    }

    public RequestStatus orchestrateChanges(@Nonnull FarmSynchronizationRequest request) {
        Objects.requireNonNull(request, "request");
        try (Ticker ignored = Timers.timerWithMetric((String)JmxHelper.timerName("farm", "synchronize", "content", request.getType().toString())).start(new String[0]);){
            String externalRepositoryId = request.getExternalRepositoryId();
            log.trace("Acquiring lock on repository with ID ({})", (Object)externalRepositoryId);
            RequestStatus requestStatus = this.mirrorRepositoryLockService.performUsingLock(externalRepositoryId, new DefaultRepositoryLockCallback.Builder<RequestStatus>(this.repositoryLockReleaseTopic).lockSuccess(id -> {
                log.trace("Acquired lock on repository with ID ({})", id);
                MirrorRepository mirrorRepository = this.mirrorRepositoryService.getMirrorRepository((String)id);
                String vmId = this.clusterService.getInformation().getLocalNode().getVmId();
                RefChangeIterator changes = this.calculateRefChanges(mirrorRepository, request);
                try {
                    String changeId = this.refChangePublisher.publish(changes, request, vmId);
                    RepositorySynchronizationRequest synchronizationRequest = new RepositorySynchronizationRequest(request, changeId, vmId);
                    this.updateRefTopic.publish(synchronizationRequest, this.resultVisitor(request, mirrorRepository));
                    this.maybeUpdateDefaultBranch(mirrorRepository);
                    this.synchronizationMetricHelper.recordSuccess(request);
                    RequestStatus requestStatus = RequestStatus.processed();
                    if (changes != null) {
                        changes.close();
                    }
                    return requestStatus;
                }
                catch (Throwable throwable) {
                    try {
                        if (changes != null) {
                            try {
                                changes.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (MirrorOperationErrorException e) {
                        return RequestStatus.failed(e, String.format("Exception while processing an event for repository with ID (%s): Some nodes failed to execute: %s", id, e));
                    }
                    catch (RepositoryOfflineException e) {
                        return RequestStatus.failed(e, String.format("Repository with ID (%s) is offline on the upstream", id));
                    }
                    catch (RuntimeException e) {
                        return RequestStatus.failed(e, String.format("Exception while processing an event for repository with ID (%s):", id));
                    }
                }
            }).lockFailure(id -> {
                log.debug("Skipping sync for repository with ID ({}) as lock could not be acquired", (Object)externalRepositoryId);
                return RequestStatus.lockFailure();
            }).build());
            return requestStatus;
        }
    }

    private RefChangeIterator calculateRefChanges(MirrorRepository mirrorRepository, FarmSynchronizationRequest request) {
        return request.getType().equals((Object)RepositorySynchronizationType.INCREMENTAL) ? this.refChangeCalculator.remoteDiff(mirrorRepository) : this.refChangeCalculator.snapshot(mirrorRepository);
    }

    private void maybeUpdateDefaultBranch(MirrorRepository mirrorRepository) {
        Optional<String> currentDefaultBranch;
        String externalRepositoryId = mirrorRepository.getId();
        ExternalRepository externalRepository = this.mirrorRepositoryService.getExternalRepository(externalRepositoryId);
        Optional<String> newDefaultBranch = externalRepository.getDefaultBranchId();
        if (newDefaultBranch.isPresent() && !newDefaultBranch.equals(currentDefaultBranch = this.mirrorRepositoryService.getDefaultBranch(mirrorRepository))) {
            if (log.isDebugEnabled()) {
                log.debug("{}: Default branch [{}] is different from current default branch [{}], updating on farm", new Object[]{MirrorDescriptionUtils.describe(externalRepository), newDefaultBranch.get(), currentDefaultBranch.orElse("-")});
            }
            DefaultBranchUpdateRequest request = new DefaultBranchUpdateRequest(externalRepositoryId, newDefaultBranch.get());
            this.repositoryDefaultBranchUpdateTopic.publish(request);
        }
    }

    private ResultVisitor<RepositorySynchronizationResponse, Void> resultVisitor(FarmSynchronizationRequest request, MirrorRepository mirrorRepository) {
        return request.getType() == RepositorySynchronizationType.INCREMENTAL ? new RepositoryIncrementalSyncEventVisitor(this.eventPublisher, mirrorRepository, this.tempDir) : new RepositorySnapshotSyncEventVisitor(this.eventPublisher, mirrorRepository, this.tempDir);
    }
}

