/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeChunk;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;

public class FarmSynchronizationRequest
implements Serializable {
    private final Instant createdAt;
    private final String externalRepositoryId;
    private final RepositorySynchronizationType type;

    public FarmSynchronizationRequest(@Nonnull String externalRepositoryId) {
        this.externalRepositoryId = Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        this.createdAt = Clock.systemUTC().instant();
        this.type = RepositorySynchronizationType.INCREMENTAL;
    }

    public FarmSynchronizationRequest(@Nonnull String externalRepositoryId, @Nonnull Clock clock) {
        this.externalRepositoryId = Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        this.createdAt = clock.instant();
        this.type = RepositorySynchronizationType.INCREMENTAL;
    }

    public FarmSynchronizationRequest(@Nonnull String externalRepositoryId, @Nonnull RepositorySynchronizationType type) {
        this.externalRepositoryId = Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        this.type = Objects.requireNonNull(type, "type");
        this.createdAt = Clock.systemUTC().instant();
    }

    public FarmSynchronizationRequest(@Nonnull RefChangeChunk chunk) {
        this.externalRepositoryId = Objects.requireNonNull(chunk, "chunk").getExternalRepositoryId();
        this.type = chunk.getSynchronizationType();
        this.createdAt = Clock.systemUTC().instant();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FarmSynchronizationRequest that = (FarmSynchronizationRequest)o;
        return Objects.equals(this.externalRepositoryId, that.externalRepositoryId) && this.type == that.type;
    }

    @Nonnull
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Nonnull
    public String getExternalRepositoryId() {
        return this.externalRepositoryId;
    }

    public RepositorySynchronizationType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.externalRepositoryId, this.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("externalRepositoryId", (Object)this.externalRepositoryId).add("type", (Object)this.type).toString();
    }
}

