/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.dmz.mirror.SynchronizationState;
import com.atlassian.bitbucket.internal.mirroring.mirror.FarmVet;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.command.MirroringCommandFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.BulkRepositoryMetadataSynchronizationOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.DefaultFarmQueueRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RequestStatus;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmOrchestrator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.InitialSyncQueue;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.RepositoriesSynchronizationRequest;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizationFailedEvent;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncCommandParameters;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class InitialSyncHelper
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(InitialSyncHelper.class);
    private final BulkRepositoryMetadataSynchronizationOperation bulkSyncOperation;
    private final EventPublisher eventPublisher;
    private final FarmOrchestrator farmOrchestrator;
    private final FarmVet farmVet;
    private final ExecutorService fetchExecutor;
    private final AtomicBoolean firstSync;
    private final long initialRetryDelay;
    private final int maxLockAcquisitionAttempts;
    private final int maxSyncAttempts;
    private final DmzMirrorFarm mirrorFarm;
    private final MirrorRepositoryService mirrorRepositoryService;
    private final MirroringCommandFactory mirroringCommandFactory;
    private final InitialSyncQueue queue;
    private final ExecutorService queuePoller;
    private final FarmQueue<FarmSynchronizationRequest> refChangesQueue;
    private final ScheduledExecutorService scheduledExecutor;
    private final InternalUpstreamService upstreamService;
    private volatile boolean running;

    @Autowired
    public InitialSyncHelper(BulkRepositoryMetadataSynchronizationOperation bulkSyncOperation, ScheduledExecutorService scheduledExecutor, EventPublisher eventPublisher, FarmOrchestrator farmOrchestrator, FarmVet farmVet, InternalUpstreamService upstreamService, DmzMirrorFarm mirrorFarm, MirroringConfig mirroringConfig, MirroringCommandFactory mirroringCommandFactory, MirrorRepositoryService mirrorRepositoryService, FarmQueue<FarmSynchronizationRequest> refChangesQueue, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, InitialSyncQueue queue) {
        this.bulkSyncOperation = bulkSyncOperation;
        this.scheduledExecutor = scheduledExecutor;
        this.eventPublisher = eventPublisher;
        this.farmOrchestrator = farmOrchestrator;
        this.farmVet = farmVet;
        this.upstreamService = upstreamService;
        this.mirroringCommandFactory = mirroringCommandFactory;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.refChangesQueue = refChangesQueue;
        this.mirrorFarm = mirrorFarm;
        this.queue = queue;
        int concurrency = mirroringConfig.getInitialSyncThreadCount();
        this.fetchExecutor = threadLocalDelegateExecutorFactory.createExecutorService((ExecutorService)new ThreadPoolExecutor(concurrency, concurrency, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"initial-sync-thread-pool", (ThreadFactories.Type)ThreadFactories.Type.DAEMON), (runnable, executor) -> {
            try {
                executor.getQueue().put(runnable);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException();
            }
        }));
        this.queuePoller = threadLocalDelegateExecutorFactory.createExecutorService(Executors.newFixedThreadPool(1, ThreadFactories.namedThreadFactory((String)"initial-sync-queue-poller", (ThreadFactories.Type)ThreadFactories.Type.DAEMON)));
        this.firstSync = new AtomicBoolean(true);
        this.initialRetryDelay = mirroringConfig.getQueueInitialRetryDelay().toMillis();
        this.maxLockAcquisitionAttempts = mirroringConfig.getMaxLockAcquisitionAttempts();
        this.maxSyncAttempts = mirroringConfig.getMaxSyncAttempts();
    }

    public void triggerFullSync() {
        log.info("Synchronizing metadata");
        this.bulkSyncOperation.perform(new RepositoriesSynchronizationRequest.Builder().build());
    }

    public void onStart() {
        this.running = true;
        this.queuePoller.submit(new PoolPoller());
    }

    public void onStop() {
        this.running = false;
        this.queuePoller.shutdownNow();
        this.fetchExecutor.shutdownNow();
    }

    void syncContent(@Nonnull Set<String> externalRepositoryIds) {
        Objects.requireNonNull(externalRepositoryIds, "externalRepositoryIds");
        if (log.isTraceEnabled()) {
            log.trace("Got externalRepositoryIds {}", externalRepositoryIds);
        }
        if (!externalRepositoryIds.isEmpty()) {
            this.queue.addRequests(externalRepositoryIds);
            log.info("Synchronizing {} git repositories.", (Object)externalRepositoryIds.size());
        }
    }

    private MirrorRepository getMirrorRepository(InitialSyncQueue.SyncRequest request) {
        try {
            return this.mirrorRepositoryService.getMirrorRepository(request.getExternalRepositoryId());
        }
        catch (NoSuchRepositoryException e) {
            log.warn("Repository with ID ({}) could not be found, ignoring", (Object)request.getExternalRepositoryId());
            this.markDoneAndCheckComplete(request);
            return null;
        }
        catch (Exception e) {
            log.warn("Something went wrong while retrieving repository with ID ({}), retrying", (Object)request.getExternalRepositoryId());
            this.handleFailed(request);
            return null;
        }
    }

    private void handleFailed(InitialSyncQueue.SyncRequest request) {
        request.resetLockAttempts();
        int attempt = request.incrementFailedAttempts();
        if (attempt < this.maxSyncAttempts) {
            long delay = request.calculateRetryDelay();
            log.debug("Request: {} Failed attempt: {}/{} retrying in {} ms", new Object[]{request, attempt, this.maxSyncAttempts, delay});
            this.scheduledExecutor.schedule(request::addToQueue, delay, TimeUnit.MILLISECONDS);
        } else {
            log.debug("Request: {} giving up: {}/{} attempts failed", new Object[]{request, attempt, this.maxSyncAttempts});
            this.publishSynchronizationFailed(request);
            this.markDoneAndCheckComplete(request);
        }
    }

    private void handleLockFailed(InitialSyncQueue.SyncRequest request) {
        int attempt = request.incrementLockAttempts();
        if (attempt < this.maxLockAcquisitionAttempts) {
            log.trace("Request: {} Failed to acquire lock: {}/{} retrying in {} ms", new Object[]{request, attempt, this.maxLockAcquisitionAttempts, this.initialRetryDelay});
            this.scheduledExecutor.schedule(request::addToQueue, this.initialRetryDelay, TimeUnit.MILLISECONDS);
        } else {
            log.debug("Request: {} could not acquire lock : {}/{} attempts failed", new Object[]{request, attempt, this.maxLockAcquisitionAttempts});
            String externalRepositoryId = this.publishSynchronizationFailed(request);
            this.refChangesQueue.offer(new DefaultFarmQueueRequest<FarmSynchronizationRequest>(new FarmSynchronizationRequest(externalRepositoryId, RepositorySynchronizationType.SNAPSHOT)));
            this.markDoneAndCheckComplete(request);
        }
    }

    private void markDoneAndCheckComplete(InitialSyncQueue.SyncRequest request) {
        log.info("Initial Synchronization for repository with ID ({}) complete", (Object)request.getExternalRepositoryId());
        if (request.markAsDone() == 0) {
            this.onDone();
        }
    }

    private void maybeDoFullSync(InitialSyncQueue.SyncRequest request, MirrorRepository repository) {
        if (!request.isFullSynced()) {
            MirrorSyncCommandParameters commandParameters = new MirrorSyncCommandParameters.Builder(repository.getUpstreamCloneUrl()).build();
            String hierarchyId = repository.getHierarchyId();
            log.debug("{}: Fetching all objects from upstream for hierarchy ID {}", MirrorDescriptionUtils.describe(repository), (Object)hierarchyId);
            Instant start = Instant.now();
            this.mirroringCommandFactory.synchronize(repository, commandParameters).call();
            this.mirrorRepositoryService.setContentHash(repository);
            log.debug("{}: Completed fetching all objects from upstream for hierarchy ID {} in {}", new Object[]{MirrorDescriptionUtils.describe(repository), hierarchyId, Duration.between(start, Instant.now())});
            request.fullSyncDone();
        } else {
            log.debug("{}: Full sync already run, skipping", MirrorDescriptionUtils.describe(repository));
        }
    }

    private void maybeResubmit(RequestStatus status, InitialSyncQueue.SyncRequest request) {
        switch (status.getState()) {
            case FAILED: {
                this.handleFailed(request);
                break;
            }
            case LOCK_FAILURE: {
                this.handleLockFailed(request);
                break;
            }
            case PROCESSED: {
                this.markDoneAndCheckComplete(request);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown request status " + String.valueOf(status));
            }
        }
    }

    private void onDone() {
        InternalUpstreamServer upstreamServer = this.upstreamService.get();
        if (upstreamServer != null) {
            if (this.firstSync.compareAndSet(true, false)) {
                log.info("Repository synchronization complete. Running farm vet");
                try {
                    this.farmVet.synchronize(upstreamServer, true);
                }
                catch (Exception e) {
                    log.error("Error running farm vet after initial sync. transitioning state to SYNCHRONIZED", (Throwable)e);
                }
                finally {
                    log.info("Farm vet on initial sync complete marking node SYNCHRONIZED");
                    this.mirrorFarm.compareAndSetSynchronizationState(SynchronizationState.METADATA_SYNCHRONIZED, SynchronizationState.SYNCHRONIZED);
                }
            }
            if (this.upstreamService.updateLastFullSyncDate(upstreamServer.getId(), new Date()) == null) {
                log.error("Failed to update last synchronization date for upstream {}", MirrorDescriptionUtils.describe(upstreamServer));
            }
        }
    }

    private String publishSynchronizationFailed(InitialSyncQueue.SyncRequest request) {
        String externalRepositoryId = request.getExternalRepositoryId();
        Repository repository = this.mirrorRepositoryService.getMirrorRepository(externalRepositoryId).getRepository();
        String upstreamServerId = Objects.requireNonNull(this.upstreamService.get(), "upstreamServer").getId();
        this.eventPublisher.publish((Object)new RepositorySynchronizationFailedEvent(this, repository, externalRepositoryId, upstreamServerId));
        return externalRepositoryId;
    }

    private void submitRepositorySync(InitialSyncQueue.SyncRequest request) {
        this.fetchExecutor.submit(() -> {
            try {
                this.syncRepository(request);
            }
            catch (Exception e) {
                log.debug("Exception processing {}", (Object)request, (Object)e);
                this.maybeResubmit(RequestStatus.failed(e), request);
            }
        });
    }

    private void syncRepository(InitialSyncQueue.SyncRequest request) {
        String externalRepositoryId = request.getExternalRepositoryId();
        MirrorRepository repository = this.mirrorRepositoryService.getMirrorRepository(externalRepositoryId);
        log.debug("{}: Starting full sync", MirrorDescriptionUtils.describe(repository));
        this.maybeDoFullSync(request, repository);
        log.debug("{}: completed full sync, starting snapshot sync", MirrorDescriptionUtils.describe(repository));
        RequestStatus status = this.farmOrchestrator.orchestrateChanges(new FarmSynchronizationRequest(externalRepositoryId, RepositorySynchronizationType.SNAPSHOT));
        log.debug("{}: attempted snapshot sync status: {}", MirrorDescriptionUtils.describe(repository), (Object)status);
        this.maybeResubmit(status, request);
    }

    private void trySyncRepository(InitialSyncQueue.SyncRequest request, MirrorRepository mirrorRepository) {
        if (mirrorRepository.getForkDepth() > 0 && mirrorRepository.getOriginInitialSyncDate() == null) {
            String originRepoId = this.mirrorRepositoryService.getOriginId(mirrorRepository);
            if (originRepoId == null || this.queue.isPendingProcessing(originRepoId)) {
                log.debug("{}: Repository has a parent that has not yet been synced adding it back onto the queue", MirrorDescriptionUtils.describe(mirrorRepository));
                this.scheduledExecutor.schedule(request::addToQueue, this.initialRetryDelay, TimeUnit.MILLISECONDS);
            } else {
                log.warn("{}: Removing repository from the queue as its parent is neither synced nor currently in the queue", MirrorDescriptionUtils.describe(mirrorRepository));
                this.publishSynchronizationFailed(request);
                this.markDoneAndCheckComplete(request);
            }
            return;
        }
        this.submitRepositorySync(request);
    }

    private class PoolPoller
    implements Runnable {
        private PoolPoller() {
        }

        @Override
        public void run() {
            while (InitialSyncHelper.this.running) {
                InitialSyncQueue.SyncRequest request = InitialSyncHelper.this.queue.takeRequest();
                if (request == null) continue;
                try {
                    this.handleRequest(request);
                }
                catch (Exception e) {
                    log.warn("Unknown error encountered while processing request {} from the initial sync queue", (Object)request);
                }
            }
        }

        private void handleRequest(InitialSyncQueue.SyncRequest request) {
            MirrorRepository mirrorRepository = InitialSyncHelper.this.getMirrorRepository(request);
            if (mirrorRepository != null) {
                log.trace("{}: Repository polled from queue", MirrorDescriptionUtils.describe(mirrorRepository));
                if (mirrorRepository.isContentSynced()) {
                    if (log.isTraceEnabled()) {
                        log.trace("{}: Repository is already synchronized, doing nothing", MirrorDescriptionUtils.describe(mirrorRepository));
                    }
                    InitialSyncHelper.this.markDoneAndCheckComplete(request);
                } else {
                    InitialSyncHelper.this.trySyncRepository(request, mirrorRepository);
                }
            }
        }
    }
}

