/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.BackoffUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitialSyncQueue {
    private static final Logger log = LoggerFactory.getLogger(InitialSyncQueue.class);
    private final long initialRetryDelay;
    private final Set<String> pendingProcessing;
    private final LinkedBlockingQueue<SyncRequest> queue;

    @Autowired
    InitialSyncQueue(MirroringConfig mirroringConfig) {
        this.initialRetryDelay = mirroringConfig.getQueueInitialRetryDelay().toMillis();
        this.pendingProcessing = Sets.newConcurrentHashSet();
        this.queue = new LinkedBlockingQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingRequests() {
        Set<String> set = this.pendingProcessing;
        synchronized (set) {
            return !this.pendingProcessing.isEmpty();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("initialRetryDelay", this.initialRetryDelay).add("pendingProcessing", this.pendingProcessing).add("queue.size", this.queue.size()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequests(@Nonnull Set<String> externalRepositoryIds) {
        Objects.requireNonNull(externalRepositoryIds, "externalRepositoryIds");
        Set<String> set = this.pendingProcessing;
        synchronized (set) {
            externalRepositoryIds.stream().map(externalRepositoryId -> new SyncRequest((String)externalRepositoryId, this.initialRetryDelay)).forEach(r -> {
                this.pendingProcessing.add(r.externalRepositoryId);
                this.maybeAdd((SyncRequest)r);
            });
        }
    }

    int getSize() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPendingProcessing(@Nonnull String externalRepositoryId) {
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        Set<String> set = this.pendingProcessing;
        synchronized (set) {
            return this.pendingProcessing.contains(externalRepositoryId);
        }
    }

    @Nullable
    SyncRequest takeRequest() {
        try {
            return this.queue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void maybeAdd(SyncRequest request) {
        boolean offered = this.queue.offer(request);
        if (!offered) {
            log.warn("Could not offer {} to initial sync queue marking as done", (Object)request);
            request.markAsDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int requestProcessed(SyncRequest syncRequest) {
        Set<String> set = this.pendingProcessing;
        synchronized (set) {
            this.pendingProcessing.remove(syncRequest.externalRepositoryId);
            return this.pendingProcessing.size();
        }
    }

    class SyncRequest {
        private final String externalRepositoryId;
        private final AtomicInteger failedAttempt = new AtomicInteger(1);
        private final long initialDelay;
        private final AtomicBoolean isFullSynced;
        private final AtomicInteger lockAttempt = new AtomicInteger(1);

        private SyncRequest(String externalRepositoryId, long initialDelay) {
            this.externalRepositoryId = Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
            this.initialDelay = initialDelay;
            this.isFullSynced = new AtomicBoolean(false);
        }

        public String getExternalRepositoryId() {
            return this.externalRepositoryId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("externalRepositoryId", (Object)this.externalRepositoryId).toString();
        }

        void addToQueue() {
            InitialSyncQueue.this.maybeAdd(this);
        }

        long calculateRetryDelay() {
            return BackoffUtils.exponentialDelay(this.initialDelay, this.failedAttempt.get());
        }

        void fullSyncDone() {
            this.isFullSynced.set(true);
        }

        int incrementFailedAttempts() {
            return this.failedAttempt.getAndIncrement();
        }

        int incrementLockAttempts() {
            return this.lockAttempt.getAndIncrement();
        }

        boolean isFullSynced() {
            return this.isFullSynced.get();
        }

        int markAsDone() {
            return InitialSyncQueue.this.requestProcessed(this);
        }

        void resetLockAttempts() {
            this.lockAttempt.set(0);
        }
    }
}

