/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.command.MirroringCommandFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeWireFormat;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncCommandParameters;
import com.google.common.collect.Iterators;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ObjectFetchHelper
implements RepositorySynchronizationHelper {
    private static final Logger log = LoggerFactory.getLogger(ObjectFetchHelper.class);
    private final MirrorRepositoryService mirrorRepositoryService;
    private final MirroringCommandFactory mirroringCommandFactory;
    private final MirroringConfig mirroringConfig;

    @Autowired
    public ObjectFetchHelper(MirrorRepositoryService mirrorRepositoryService, MirroringCommandFactory mirroringCommandFactory, MirroringConfig mirroringConfig) {
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.mirroringCommandFactory = mirroringCommandFactory;
        this.mirroringConfig = mirroringConfig;
    }

    @Override
    public void perform(@Nonnull Stream<String> changes, @Nonnull String externalRepositoryId) {
        Objects.requireNonNull(changes, "changes");
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        MirrorRepository mirrorRepository = this.mirrorRepositoryService.getMirrorRepository(externalRepositoryId);
        String cloneUrl = mirrorRepository.getUpstreamCloneUrl();
        Iterator refspecs = changes.filter(RefChangeWireFormat::isFetchInstruction).map(RefChangeWireFormat::wireToRefspec).iterator();
        Iterators.partition(refspecs, (int)this.mirroringConfig.getMaxChunkSize()).forEachRemaining(chunk -> {
            log.trace("Executing object fetch with refspec: {}", chunk);
            MirrorSyncCommandParameters commandParameter = new MirrorSyncCommandParameters.Builder(cloneUrl).refspecs((Iterable)chunk).withTags(true).prune(false).withEnvironment("BB_IS_MIRROR", "1").build();
            this.mirroringCommandFactory.synchronize(mirrorRepository, commandParameter).call();
        });
        log.debug("Git objects have been fetched for repository with ID ({})", (Object)externalRepositoryId);
    }
}

