/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.exception.MirrorOperationErrorException;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangePublisher;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeWireFormat;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ErrorResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ResultVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.SingleResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizationFailedOnFarmEvent;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizedOnFarmEvent;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryIncrementalSyncEventVisitor
implements ResultVisitor<RepositorySynchronizationResponse, Void> {
    private static final Logger log = LoggerFactory.getLogger(RepositoryIncrementalSyncEventVisitor.class);
    private final EventPublisher eventPublisher;
    private final MirrorRepository mirrorRepository;
    private final Path tempDir;

    RepositoryIncrementalSyncEventVisitor(@Nonnull EventPublisher eventPublisher, @Nonnull MirrorRepository mirrorRepository, @Nonnull Path tempDir) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        this.mirrorRepository = Objects.requireNonNull(mirrorRepository, "mirrorRepository");
        this.tempDir = Objects.requireNonNull(tempDir, "tempDir");
    }

    @Override
    public Void visit(SingleResult<RepositorySynchronizationResponse> result) {
        if (!new RepositorySynchronizationResponse(RefChangePublisher.EMPTY_CHANGE_ID).equals(result.get())) {
            Collection<RefChange> refChanges = this.calculateRefChanges(result.get().getChangeId(), this.mirrorRepository.getId());
            this.eventPublisher.publish((Object)new RepositorySynchronizedOnFarmEvent.Builder(this, this.mirrorRepository.getRepository()).cloneLinks(this.mirrorRepository.getCloneLinks()).externalRepositoryId(this.mirrorRepository.getId()).refChanges(refChanges).syncType(RepositorySynchronizationType.INCREMENTAL).build());
        }
        return null;
    }

    @Override
    public Void visit(ErrorResult<RepositorySynchronizationResponse> results) {
        this.eventPublisher.publish((Object)new RepositorySynchronizationFailedOnFarmEvent(this, this.mirrorRepository.getRepository(), this.mirrorRepository.getId()));
        log.error("{}: Update-ref failed for repository with error: {}", MirrorDescriptionUtils.describe(this.mirrorRepository), results.getErrors());
        throw new MirrorOperationErrorException(results.getResults(), results.getErrors());
    }

    private Collection<RefChange> calculateRefChanges(String changeId, String externalRepositoryId) {
        Path changes = this.tempDir.resolve("ref-changes").resolve(externalRepositoryId).resolve(changeId);
        try {
            Collection collection;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(changes, new OpenOption[0]), StandardCharsets.UTF_8));
            try {
                collection = (Collection)reader.lines().map(RefChangeWireFormat::wireToRefChange).collect(MoreCollectors.toImmutableList());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not read from changes: " + String.valueOf(changes), e);
                }
            }
            reader.close();
            return collection;
        }
        finally {
            log.trace("Cleaning up {}", (Object)changes);
            try {
                Files.delete(changes);
            }
            catch (IOException e) {
                log.error("Could not delete changes: {}", (Object)changes, (Object)e);
            }
        }
    }
}

