/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.RepositoryMetadataSynchronizedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.InitialSyncHelper;
import com.atlassian.event.api.EventListener;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryMetadataSynchronizationListener {
    private static final Logger log = LoggerFactory.getLogger(RepositoryMetadataSynchronizationListener.class);
    private final InitialSyncHelper initialSyncHelper;

    @Autowired
    public RepositoryMetadataSynchronizationListener(InitialSyncHelper initialSyncHelper) {
        this.initialSyncHelper = initialSyncHelper;
    }

    @EventListener
    public void onRepositoryMetadataSynchronizedEvent(@Nonnull RepositoryMetadataSynchronizedEvent event) {
        Objects.requireNonNull(event, "event");
        log.debug("Syncing content {}", event.getSyncedExternalRepositoryIds());
        this.initialSyncHelper.syncContent(event.getSyncedExternalRepositoryIds());
    }
}

