/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.metrics.JmxHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositoryOutOfSyncMXBean;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.RepositorySyncDiagnosticsService;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryOutOfSyncJmxMetrics
implements RepositoryOutOfSyncMXBean {
    private static final String METRIC_NAME = "OutOfSync";
    private final Supplier<Integer> contentCountSupplier;

    @Autowired
    public RepositoryOutOfSyncJmxMetrics(RepositorySyncDiagnosticsService repositorySyncDiagnosticsService, JmxHelper jmxHelper, MirroringConfig mirroringConfig) {
        if (mirroringConfig.isRepositorySyncDiagnosticsEnabled()) {
            this.contentCountSupplier = Suppliers.memoizeWithExpiration(() -> repositorySyncDiagnosticsService.getLocalDelayedSyncRepositories().size(), (long)30L, (TimeUnit)TimeUnit.SECONDS);
            jmxHelper.maybeRegisterMBean(JmxHelper.metricName("farm", "synchronize", METRIC_NAME), this);
        } else {
            this.contentCountSupplier = () -> 0;
        }
    }

    @Override
    public int getContent() {
        return (Integer)this.contentCountSupplier.get();
    }
}

