/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.exception.MirrorOperationErrorException;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeWireFormat;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ConflictResults;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ErrorResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ResultVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.SingleResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizationFailedOnFarmEvent;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizedOnFarmEvent;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositorySnapshotSyncEventVisitor
implements ResultVisitor<RepositorySynchronizationResponse, Void> {
    private static final Logger log = LoggerFactory.getLogger(RepositorySnapshotSyncEventVisitor.class);
    private final EventPublisher eventPublisher;
    private final MirrorRepository mirrorRepository;
    private final Path tempDir;

    RepositorySnapshotSyncEventVisitor(@Nonnull EventPublisher eventPublisher, @Nonnull MirrorRepository mirrorRepository, @Nonnull Path tempDir) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        this.mirrorRepository = Objects.requireNonNull(mirrorRepository, "mirrorRepository");
        this.tempDir = Objects.requireNonNull(tempDir, "tempDir");
    }

    @Override
    public Void visit(SingleResult<RepositorySynchronizationResponse> result) {
        if (!result.get().isEmpty() && this.mirrorRepository.getInitialSyncDate() != null) {
            Collection<RefChange> refChanges = this.calculateRefChanges(result.get().getChangeId(), this.mirrorRepository.getId(), result.get().getChanges());
            this.eventPublisher.publish((Object)new RepositorySynchronizedOnFarmEvent.Builder(this, this.mirrorRepository.getRepository()).cloneLinks(this.mirrorRepository.getCloneLinks()).externalRepositoryId(this.mirrorRepository.getId()).refChanges(refChanges).syncType(RepositorySynchronizationType.SNAPSHOT).build());
        }
        return null;
    }

    @Override
    public Void visit(ConflictResults<RepositorySynchronizationResponse> results) {
        HashMap<Integer, RefChangeType> refChangeLocations = new HashMap<Integer, RefChangeType>();
        results.getResults().forEach((nodeResponse, nodes) -> nodeResponse.getChanges().forEach((changeLocation, changeType) -> refChangeLocations.merge((Integer)changeLocation, (RefChangeType)changeType, (existingType, newType) -> existingType == newType ? existingType : RefChangeType.UPDATE)));
        String changeId = ((RepositorySynchronizationResponse)((Map.Entry)results.getResults().entrySet().stream().findFirst().get()).getKey()).getChangeId();
        if (this.mirrorRepository.getInitialSyncDate() != null) {
            Collection<RefChange> refChanges = this.calculateRefChanges(changeId, this.mirrorRepository.getId(), refChangeLocations);
            this.eventPublisher.publish((Object)new RepositorySynchronizedOnFarmEvent.Builder(this, this.mirrorRepository.getRepository()).cloneLinks(this.mirrorRepository.getCloneLinks()).externalRepositoryId(this.mirrorRepository.getId()).refChanges(refChanges).syncType(RepositorySynchronizationType.SNAPSHOT).build());
        }
        return null;
    }

    @Override
    public Void visit(ErrorResult<RepositorySynchronizationResponse> results) {
        this.eventPublisher.publish((Object)new RepositorySynchronizationFailedOnFarmEvent(this, this.mirrorRepository.getRepository(), this.mirrorRepository.getId()));
        log.error("{}: Snapshot failed for repository with error: {}", MirrorDescriptionUtils.describe(this.mirrorRepository), results.getErrors());
        throw new MirrorOperationErrorException(results.getResults(), results.getErrors());
    }

    private Collection<RefChange> calculateRefChanges(String changeId, String externalRepositoryId, Map<Integer, RefChangeType> refChangeInfo) {
        Path changes = this.tempDir.resolve("ref-changes").resolve(externalRepositoryId).resolve(changeId);
        try {
            ArrayList<RefChange> arrayList;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(changes, new OpenOption[0]), StandardCharsets.UTF_8));
            try {
                String wireRefChange = reader.readLine();
                int currentLineNumber = 1;
                ArrayList<RefChange> refChanges = new ArrayList<RefChange>();
                while (wireRefChange != null) {
                    if (refChangeInfo.containsKey(currentLineNumber)) {
                        refChanges.add((RefChange)((SimpleRefChange.Builder)new SimpleRefChange.Builder(RefChangeWireFormat.wireToRefChange(wireRefChange)).type(refChangeInfo.get(currentLineNumber))).build());
                    }
                    wireRefChange = reader.readLine();
                    ++currentLineNumber;
                }
                arrayList = refChanges;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not read from changes: " + String.valueOf(changes), e);
                }
            }
            reader.close();
            return arrayList;
        }
        finally {
            log.debug("cleaning up {}", (Object)changes);
            try {
                Files.delete(changes);
            }
            catch (IOException e) {
                log.error("Could not delete changes: {}", (Object)changes, (Object)e);
            }
        }
    }
}

