/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.dmz.mirror.SynchronizationState;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeCalculator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeIterator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangePublisher;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeWireFormat;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.atlassian.bitbucket.server.StorageService;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositorySynchronizationOperation
implements MirrorOperation<RepositorySynchronizationRequest, RepositorySynchronizationResponse> {
    private static final Logger log = LoggerFactory.getLogger(RepositorySynchronizationOperation.class);
    private final boolean cleanup;
    private final ClusterService clusterService;
    private final DmzMirrorFarm mirrorFarm;
    private final MirrorRepositoryService mirrorRepositoryService;
    private final Set<SynchronizationState> readyStates;
    private final RefChangeCalculator refChangeCalculator;
    private final RepositorySynchronizationHelper synchronizationHelper;
    private final Path tempDir;

    RepositorySynchronizationOperation(ClusterService clusterService, DmzMirrorFarm mirrorFarm, MirrorRepositoryService mirrorRepositoryService, RefChangeCalculator refChangeCalculator, RepositorySynchronizationHelper synchronizationHelper, StorageService storageService, boolean cleanup) {
        this.cleanup = cleanup;
        this.clusterService = clusterService;
        this.mirrorFarm = mirrorFarm;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.synchronizationHelper = synchronizationHelper;
        this.refChangeCalculator = refChangeCalculator;
        this.readyStates = ImmutableSet.of((Object)SynchronizationState.METADATA_SYNCHRONIZED, (Object)SynchronizationState.SYNCHRONIZED);
        this.tempDir = storageService.getTempDir();
    }

    @Override
    @Nonnull
    public RepositorySynchronizationResponse perform(@Nonnull RepositorySynchronizationRequest request) {
        RepositorySynchronizationResponse repositorySynchronizationResponse;
        MirrorRepository mirrorRepository;
        Objects.requireNonNull(request, "request");
        String externalRepositoryId = request.getExternalRepositoryId();
        if (!this.readyStates.contains(this.mirrorFarm.getSynchronizationState())) {
            return new RepositorySynchronizationResponse(request.getChangeId());
        }
        try {
            mirrorRepository = this.mirrorRepositoryService.getMirrorRepository(externalRepositoryId);
        }
        catch (NoSuchRepositoryException e) {
            return new RepositorySynchronizationResponse(request.getChangeId());
        }
        if (this.checkRepositoryReady(request, mirrorRepository)) {
            return new RepositorySynchronizationResponse(request.getChangeId());
        }
        Path changes = this.tempDir.resolve("ref-changes").resolve(externalRepositoryId).resolve(request.getChangeId());
        log.trace("Request: {} refChanges: {}, helper: {}", new Object[]{request, changes, this.synchronizationHelper});
        if (request.getChangeId().equals(RefChangePublisher.EMPTY_CHANGE_ID)) {
            this.synchronizationHelper.perform(Stream.empty(), externalRepositoryId);
            return new RepositorySynchronizationResponse(request.getChangeId());
        }
        if (!Files.exists(changes, new LinkOption[0])) {
            log.error("Could not find changes: {} for request: {}", (Object)changes, (Object)request);
            throw new IllegalStateException("Could not find changes " + String.valueOf(changes));
        }
        if (request.getType().equals((Object)RepositorySynchronizationType.SNAPSHOT)) {
            log.debug("Snapshot synchronization for repository with ID ({})", (Object)externalRepositoryId);
            HashMap<Integer, RefChangeType> changeInfo = new HashMap<Integer, RefChangeType>();
            String localNodeVmId = this.clusterService.getInformation().getLocalNode().getVmId();
            try (RefChangeIterator refChanges = this.refChangeCalculator.localDiff(changes, mirrorRepository);){
                Stream<String> snapshotStream = Streams.stream((Iterator)refChanges).peek(mirrorFarmRefChange -> {
                    if (!(mirrorRepository.getInitialSyncDate() == null && localNodeVmId.equals(request.getOrchestratingNodeVmId()) || mirrorFarmRefChange.getChangeLocation() <= 0)) {
                        changeInfo.put(mirrorFarmRefChange.getChangeLocation(), mirrorFarmRefChange.getType());
                    }
                }).map(RefChangeWireFormat::refChangeToWire);
                this.synchronizationHelper.perform(snapshotStream, externalRepositoryId);
            }
            return new RepositorySynchronizationResponse(request.getChangeId(), changeInfo);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(changes, new OpenOption[0]), StandardCharsets.UTF_8));
        try {
            String vmId;
            this.synchronizationHelper.perform(reader.lines(), externalRepositoryId);
            if (this.cleanup && !(vmId = this.clusterService.getInformation().getLocalNode().getVmId()).equals(request.getOrchestratingNodeVmId())) {
                log.debug("End of operation cleaning up {}", (Object)changes);
                try {
                    Files.delete(changes);
                }
                catch (IOException e) {
                    log.error("Could not delete changes: {}", (Object)changes, (Object)e);
                }
            }
            repositorySynchronizationResponse = new RepositorySynchronizationResponse(request.getChangeId());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Could not read from changes: {}", (Object)changes);
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return repositorySynchronizationResponse;
    }

    private boolean checkRepositoryReady(RepositorySynchronizationRequest request, MirrorRepository mirrorRepository) {
        String localNodeVmId = this.clusterService.getInformation().getLocalNode().getVmId();
        boolean localOrchestrator = localNodeVmId.equals(request.getOrchestratingNodeVmId());
        String externalRepositoryId = request.getExternalRepositoryId();
        if (mirrorRepository.getForkDepth() > 0 && mirrorRepository.getOriginInitialSyncDate() == null) {
            log.debug("Repository with ID ({}) has an origin that has not yet been synchronized. Faking success", (Object)externalRepositoryId);
            return true;
        }
        if (mirrorRepository.getInitialSyncDate() == null && request.getType().equals((Object)RepositorySynchronizationType.INCREMENTAL)) {
            log.debug("Repository with ID ({}) has not yet been synchronized. Faking success", (Object)externalRepositoryId);
            return true;
        }
        if (mirrorRepository.getInitialSyncDate() == null && request.getType().equals((Object)RepositorySynchronizationType.SNAPSHOT) && !localOrchestrator) {
            log.debug("Repository with ID ({}) has not yet been synchronized. Faking success", (Object)externalRepositoryId);
            return true;
        }
        return false;
    }
}

