/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeChunk;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;

public class RepositorySynchronizationRequest
implements Serializable {
    private final String changeId;
    private final String externalRepositoryId;
    private final String orchestratingNodeVmId;
    private final RepositorySynchronizationType type;

    public RepositorySynchronizationRequest(@Nonnull FarmSynchronizationRequest request, @Nonnull String changeId, @Nonnull String orchestratingNodeVmId) {
        Objects.requireNonNull(request, "request");
        this.orchestratingNodeVmId = Objects.requireNonNull(orchestratingNodeVmId, "orchestratingNodeVmId");
        this.changeId = Objects.requireNonNull(changeId, "changeId");
        this.externalRepositoryId = request.getExternalRepositoryId();
        this.type = request.getType();
    }

    public RepositorySynchronizationRequest(@Nonnull RefChangeChunk chunk, @Nonnull String changeId) {
        Objects.requireNonNull(chunk, "chunk");
        Objects.requireNonNull(changeId, "changeId");
        this.externalRepositoryId = chunk.getExternalRepositoryId();
        this.orchestratingNodeVmId = chunk.getOrchestratingNodeVmId();
        this.type = chunk.getSynchronizationType();
        this.changeId = changeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositorySynchronizationRequest that = (RepositorySynchronizationRequest)o;
        return Objects.equals(this.changeId, that.changeId) && Objects.equals(this.externalRepositoryId, that.externalRepositoryId) && Objects.equals(this.orchestratingNodeVmId, that.orchestratingNodeVmId) && Objects.equals(this.type, that.type);
    }

    @Nonnull
    public String getChangeId() {
        return this.changeId;
    }

    @Nonnull
    public String getExternalRepositoryId() {
        return this.externalRepositoryId;
    }

    public String getOrchestratingNodeVmId() {
        return this.orchestratingNodeVmId;
    }

    public RepositorySynchronizationType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.changeId, this.externalRepositoryId, this.orchestratingNodeVmId, this.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("changeId", (Object)this.changeId).add("externalRepositoryId", (Object)this.externalRepositoryId).add("orchestratingNodeVmId", (Object)this.orchestratingNodeVmId).add("type", (Object)this.type).toString();
    }
}

