/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangePublisher;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class RepositorySynchronizationResponse
implements Serializable {
    private final String changeId;
    private final Map<Integer, RefChangeType> changes;

    public RepositorySynchronizationResponse(@Nonnull String changeId) {
        this(Objects.requireNonNull(changeId, "changeId"), (Map<Integer, RefChangeType>)ImmutableMap.of());
    }

    public RepositorySynchronizationResponse(@Nonnull String changeId, @Nonnull Map<Integer, RefChangeType> changes) {
        Objects.requireNonNull(changeId, "changeId");
        Objects.requireNonNull(changes, "changes");
        this.changeId = changeId;
        this.changes = ImmutableMap.copyOf(changes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositorySynchronizationResponse that = (RepositorySynchronizationResponse)o;
        return Objects.equals(this.changeId, that.changeId) && Objects.equals(this.changes, that.changes);
    }

    public Map<Integer, RefChangeType> getChanges() {
        return this.changes;
    }

    @Nonnull
    public String getChangeId() {
        return this.changeId;
    }

    public int hashCode() {
        return Objects.hash(this.changeId, this.changes);
    }

    public boolean isEmpty() {
        return RefChangePublisher.EMPTY_CHANGE_ID.equals(this.changeId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("changeId", (Object)this.changeId).add("changes", this.changes).toString();
    }
}

