/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.metrics.JmxHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.util.profiling.MetricTimer;
import com.atlassian.util.profiling.Metrics;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class SynchronizationMetricHelper {
    private final Clock clock;
    private final MetricTimer successTimer;

    public SynchronizationMetricHelper() {
        this(Clock.systemUTC());
    }

    public SynchronizationMetricHelper(Clock clock) {
        this.clock = clock;
        this.successTimer = Metrics.timer((String)JmxHelper.timerName("request", "synchronize", "cycle-time"));
    }

    void recordSuccess(FarmSynchronizationRequest request) {
        this.successTimer.update(Duration.between(request.getCreatedAt(), this.clock.instant()).toMillis(), TimeUnit.MILLISECONDS);
    }
}

