/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.command.MirroringCommandFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.refchange.RefChangeWireFormat;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.MirrorRefChangeUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.RepositorySynchronizationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizedEvent;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateRefHelper
implements RepositorySynchronizationHelper {
    private static final Logger log = LoggerFactory.getLogger(UpdateRefHelper.class);
    private final EventPublisher eventPublisher;
    private final MirrorRepositoryService mirrorRepositoryService;
    private final MirroringCommandFactory mirroringGitCommandFactory;

    @Autowired
    public UpdateRefHelper(EventPublisher eventPublisher, MirrorRepositoryService mirrorRepositoryService, MirroringCommandFactory mirroringGitCommandFactory) {
        this.eventPublisher = eventPublisher;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.mirroringGitCommandFactory = mirroringGitCommandFactory;
    }

    @Override
    public void perform(@Nonnull Stream<String> changes, @Nonnull String externalRepositoryId) {
        MirrorRepository mirrorRepository = this.mirrorRepositoryService.getMirrorRepository(externalRepositoryId);
        Repository repository = mirrorRepository.getRepository();
        ArrayList<RefChange> refChanges = new ArrayList<RefChange>();
        RefChangeIterator refChangeIterator = new RefChangeIterator(changes.map(RefChangeWireFormat::wireToRefChange));
        while (refChangeIterator.hasNext()) {
            Iterator<String> instructions = StreamSupport.stream(Spliterators.spliteratorUnknownSize(refChangeIterator, 16), false).peek(refChanges::add).map(RefChangeWireFormat::refChangeToUpdateInstructions).iterator();
            this.mirroringGitCommandFactory.updateRefs(repository, instructions).call();
            refChangeIterator = new RefChangeIterator(refChangeIterator.getSkipped());
        }
        this.mirrorRepositoryService.setContentHash(mirrorRepository);
        this.eventPublisher.publish((Object)new RepositorySynchronizedEvent(this, repository, mirrorRepository.getId(), refChanges, mirrorRepository.getUpstreamId()));
        log.debug("{}: Refs have been updated for repository", MirrorDescriptionUtils.describe(mirrorRepository));
    }

    private static class RefChangeIterator
    implements Iterator<RefChange> {
        private final PeekingIterator<RefChange> changes;
        private final Set<RefChange> skipped;

        private RefChangeIterator(Stream<RefChange> changes) {
            this.changes = Iterators.peekingIterator(changes.iterator());
            this.skipped = new LinkedHashSet<RefChange>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            PeekingIterator<RefChange> peekingIterator = this.changes;
            synchronized (peekingIterator) {
                return this.changes.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RefChange next() {
            PeekingIterator<RefChange> peekingIterator = this.changes;
            synchronized (peekingIterator) {
                RefChange result = (RefChange)this.changes.next();
                while (this.changes.hasNext() && MirrorRefChangeUtils.areColliding(result, (RefChange)this.changes.peek())) {
                    this.skipped.add((RefChange)this.changes.next());
                }
                return result;
            }
        }

        private Stream<RefChange> getSkipped() {
            return this.skipped.stream();
        }
    }
}

