/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic;

import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.MirrorOperationDecorator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopicSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.MetricCollectingOperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.MultiThreadedOperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.OperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.OperationCallbackMetrics;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.TopicOperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.TopicOperationCallbackAdapter;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.TopicOperationCallbackLogger;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.AuthenticatedMirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MetricCollectingMirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MultiThreadedMirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.RetryingMirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.TopicOperation;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultMirrorOperationDecorator
implements MirrorOperationDecorator {
    private final ConcurrentHashMap<String, OperationCallbackMetrics> callbackMetrics;
    private final ExecutorService farmOperationCallbackExecutor;
    private final ExecutorService farmOperationExecutor;
    private final InternalUpstreamService internalUpstreamService;
    private final ApplicationPropertiesService propertiesService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final UpstreamUserHelper upstreamUserHelper;

    @Autowired
    public DefaultMirrorOperationDecorator(ApplicationPropertiesService propertiesService, @Qualifier(value="farmOperationCallbackExecutor") ExecutorService farmOperationCallbackExecutor, @Qualifier(value="farmOperationExecutor") ExecutorService farmOperationExecutor, ScheduledExecutorService scheduledExecutorService, InternalUpstreamService internalUpstreamService, UpstreamUserHelper upstreamUserHelper) {
        this.propertiesService = propertiesService;
        this.farmOperationCallbackExecutor = farmOperationCallbackExecutor;
        this.farmOperationExecutor = farmOperationExecutor;
        this.scheduledExecutorService = scheduledExecutorService;
        this.internalUpstreamService = internalUpstreamService;
        this.upstreamUserHelper = upstreamUserHelper;
        this.callbackMetrics = new ConcurrentHashMap();
    }

    @Override
    @Nonnull
    public <R extends Serializable> TopicOperationCallback<R> decorateCallback(@Nonnull OperationCallback<R> callback, @Nonnull RequestReplyTopicSettings settings) {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(settings, "settings");
        return new MultiThreadedOperationCallback<R>(this.farmOperationCallbackExecutor, this.scheduledExecutorService, settings, new TopicOperationCallbackLogger<R>(this.maybeDecorateWithMetrics(new TopicOperationCallbackAdapter<R>(callback), settings), settings.getName()));
    }

    @Override
    @Nonnull
    public <Q extends Serializable, R extends Serializable> TopicOperation<Q, R> decorateOperation(@Nonnull MirrorOperation<Q, R> operation, @Nonnull RequestReplyTopicSettings settings) {
        Objects.requireNonNull(operation, "operation");
        Objects.requireNonNull(settings, "settings");
        return this.maybeDecorateWithRetry(new MultiThreadedMirrorOperation<Q, R>(this.farmOperationExecutor, this.scheduledExecutorService, settings, new AuthenticatedMirrorOperation<Q, R>(this.internalUpstreamService, this.upstreamUserHelper, this.maybeDecorateWithMetrics(operation, settings))), settings);
    }

    @VisibleForTesting
    <R extends Serializable> TopicOperationCallback<R> maybeDecorateWithMetrics(@Nonnull TopicOperationCallback<R> callback, @Nonnull RequestReplyTopicSettings settings) {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(settings, "settings");
        if (this.propertiesService.isJmxEnabled()) {
            OperationCallbackMetrics metrics = this.callbackMetrics.computeIfAbsent(settings.getName(), name -> new OperationCallbackMetrics(settings));
            return new MetricCollectingOperationCallback<R>(callback, metrics);
        }
        return callback;
    }

    @VisibleForTesting
    <Q extends Serializable, R extends Serializable> MirrorOperation<Q, R> maybeDecorateWithMetrics(MirrorOperation<Q, R> operation, RequestReplyTopicSettings settings) {
        Objects.requireNonNull(operation, "operation");
        Objects.requireNonNull(settings, "settings");
        if (this.propertiesService.isJmxEnabled()) {
            return new MetricCollectingMirrorOperation<Q, R>(operation, settings.getName());
        }
        return operation;
    }

    @VisibleForTesting
    <Q extends Serializable, R extends Serializable> TopicOperation<Q, R> maybeDecorateWithRetry(@Nonnull TopicOperation<Q, R> operation, @Nonnull RequestReplyTopicSettings settings) {
        Objects.requireNonNull(operation, "operation");
        Objects.requireNonNull(settings, "settings");
        if (settings.getOperationMaxAttempts() > 1) {
            return new RetryingMirrorOperation<Q, R>(settings, this.scheduledExecutorService, operation);
        }
        return operation;
    }
}

