/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.TopicOperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.id.CorrelationId;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InflightOperation<R extends Serializable> {
    private static final Logger log = LoggerFactory.getLogger(InflightOperation.class);
    private final Set<NodeVmId> anticipatedResponders;
    private final TopicOperationCallback<R> callback;
    private final Clock clock;
    private final AtomicBoolean complete;
    private final CorrelationId correlationId;
    private final Deque<Reply<R>> replies = new ConcurrentLinkedDeque<Reply<R>>();
    private final Instant startTime;
    private volatile boolean evicted;
    private volatile boolean timeout;

    InflightOperation(@Nonnull Set<NodeVmId> anticipatedResponders, @Nonnull TopicOperationCallback<R> callback, @Nonnull Clock clock, @Nonnull CorrelationId correlationId) {
        this.anticipatedResponders = Sets.newConcurrentHashSet(anticipatedResponders);
        this.callback = Objects.requireNonNull(callback, "callback");
        this.clock = Objects.requireNonNull(clock, "clock");
        this.complete = new AtomicBoolean(false);
        this.correlationId = correlationId;
        this.evicted = false;
        this.startTime = clock.instant();
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    void addResult(@Nonnull MessageEvent<TopicResponse<R>> event) {
        Objects.requireNonNull(event, "event");
        ClusterNode source = event.getSource();
        TopicResponse response = (TopicResponse)event.getMessage();
        NodeVmId nodeVmId = NodeVmId.nodeVmId(source.getVmId());
        if (this.complete.get()) {
            log.warn("[{}] Received response: {} from: {} for operation that has already completed", new Object[]{this.correlationId, response, nodeVmId});
            return;
        }
        Duration responseTime = Duration.between(response.getStartTime(), this.clock.instant());
        if (log.isTraceEnabled()) {
            log.trace("[{}] Received response: {} from: {} {} ms since request sent. Replies: {}", new Object[]{this.correlationId, response, nodeVmId, responseTime.toMillis(), this.replies});
        }
        if (!this.anticipatedResponders.contains(nodeVmId)) {
            log.debug("[{}] Received unexpected response: {} from: {} {} ms since request sent. Replies: {}", new Object[]{this.correlationId, response, nodeVmId, responseTime.toMillis(), this.replies});
            return;
        }
        if (response.notReadyForProcessing()) {
            this.replies.add(new Reply(nodeVmId, true));
        } else if (response.getResult().isPresent()) {
            this.replies.add(new Reply<Serializable>(nodeVmId, (Serializable)response.getResult().get()));
        } else {
            Throwable error = response.getError().orElse(new IllegalStateException("Result or exception must be set"));
            this.replies.add(new Reply(nodeVmId, error));
        }
        this.maybeDoCompletionCallback();
    }

    boolean isComplete() {
        return this.complete.get();
    }

    void markEvicted() {
        if (this.complete.get()) {
            log.warn("[{}] Attempting to evict operation that has already completed", (Object)this.correlationId);
            return;
        }
        this.evicted = true;
        this.maybeDoCompletionCallback();
    }

    void markTimeout() {
        if (this.complete.get()) {
            log.warn("[{}] Attempting to timeout operation that has already completed", (Object)this.correlationId);
            return;
        }
        this.timeout = true;
        this.maybeDoCompletionCallback();
    }

    void maybeDoCompletionCallback() {
        boolean complete;
        if (this.complete.get()) {
            return;
        }
        Set<NodeVmId> acknowledgedNodes = this.acknowledgedNodes();
        boolean bl = complete = acknowledgedNodes.containsAll(this.anticipatedResponders) || this.timeout || this.evicted;
        if (log.isTraceEnabled()) {
            log.trace("[{}] complete: {} timeout: {} evicted: {} waiting for {}", new Object[]{this.correlationId, complete, this.timeout, this.evicted, Sets.difference(this.anticipatedResponders, acknowledgedNodes)});
        }
        if (complete && this.complete.compareAndSet(false, true)) {
            log.debug("[{}] Operation completed! timeout: {} evicted: {}", new Object[]{this.correlationId, this.timeout, this.evicted});
            Duration responseTime = Duration.between(this.startTime, this.clock.instant());
            Map results = this.replies.stream().filter(r -> r.getResult().isPresent()).collect(Collectors.groupingBy(t -> (Serializable)t.getResult().get(), Collectors.mapping(Reply::getNodeVmId, Collectors.toList())));
            Map<Class<? extends Throwable>, List<NodeVmId>> errors = this.replies.stream().filter(r -> r.getException().isPresent()).collect(Collectors.groupingBy(t -> t.getException().get().getClass(), Collectors.mapping(Reply::getNodeVmId, Collectors.toList())));
            if (this.timeout || this.evicted) {
                this.callback.onTimeout(responseTime, this.correlationId, (Set<NodeVmId>)Sets.difference(this.anticipatedResponders, acknowledgedNodes), results, errors);
            } else if (errors.isEmpty() && results.size() == 1) {
                this.callback.onSuccess(responseTime, this.correlationId, results.keySet().iterator().next());
            } else if (errors.isEmpty() && results.size() > 1) {
                this.callback.onConflict(responseTime, this.correlationId, results);
            } else if (!errors.isEmpty()) {
                this.callback.onError(responseTime, this.correlationId, results, errors);
            } else {
                this.callback.onError(responseTime, this.correlationId, results, errors);
            }
        }
    }

    void updateAnticipatedResponders(@Nonnull Set<NodeVmId> currentNodes) {
        Objects.requireNonNull(currentNodes);
        if (this.complete.get()) {
            log.warn("[{}] attempting to update anticipated responses for operation that has already completed, ignoring.", (Object)this.correlationId);
            return;
        }
        Sets.SetView removedNodes = Sets.difference(this.anticipatedResponders, currentNodes);
        this.anticipatedResponders.removeAll((Collection<?>)removedNodes);
        if (log.isTraceEnabled()) {
            log.trace("[{}] Updated anticipated responses anticipated: {} acknowledged: {}", new Object[]{this.correlationId, this.anticipatedResponders, this.acknowledgedNodes()});
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] Updated anticipated responses anticipated: {} acknowledged: {}", new Object[]{this.correlationId, this.anticipatedResponders.size(), this.replies.size()});
        }
        this.maybeDoCompletionCallback();
    }

    private Set<NodeVmId> acknowledgedNodes() {
        return this.replies.stream().map(Reply::getNodeVmId).collect(Collectors.toSet());
    }

    private static class Reply<R extends Serializable> {
        private final NodeVmId nodeVmId;
        private boolean notReady;
        private R result;
        private Throwable throwable;

        private Reply(NodeVmId nodeVmId, R result) {
            this(nodeVmId, false);
            this.result = result;
        }

        private Reply(NodeVmId nodeVmId, Throwable throwable) {
            this(nodeVmId, false);
            this.throwable = throwable;
        }

        private Reply(NodeVmId nodeVmId, boolean notReady) {
            this.nodeVmId = nodeVmId;
            this.notReady = notReady;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("nodeVmId", (Object)this.nodeVmId).add("throwable", (Object)this.throwable).add("result", this.result).add("notReady", this.notReady).toString();
        }

        @Nonnull
        private Optional<Throwable> getException() {
            return Optional.ofNullable(this.throwable);
        }

        private NodeVmId getNodeVmId() {
            return this.nodeVmId;
        }

        @Nonnull
        private Optional<R> getResult() {
            return Optional.ofNullable(this.result);
        }
    }
}

