/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.InflightOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.MirrorOperationDecorator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopicSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.OperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.TopicOperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.id.CorrelationId;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.TopicListener;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Clock;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InflightOperationListener<R extends Serializable>
implements TopicListener<TopicResponse<R>> {
    private static final Logger log = LoggerFactory.getLogger(InflightOperationListener.class);
    private final Clock clock;
    private final MirrorOperationDecorator decorator;
    private final ConcurrentHashMap<CorrelationId, InflightOperation<R>> inFlightOperations;
    private final ScheduledExecutorService scheduledExecutorService;
    private final RequestReplyTopicSettings settings;

    @VisibleForTesting
    InflightOperationListener(@Nonnull Clock clock, @Nonnull MirrorOperationDecorator decorator, @Nonnull RequestReplyTopicSettings settings, @Nonnull ScheduledExecutorService scheduledExecutorService) {
        this.clock = Objects.requireNonNull(clock, "clock");
        this.decorator = Objects.requireNonNull(decorator, "decorator");
        this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService, "scheduledExecutorService");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.inFlightOperations = new ConcurrentHashMap();
    }

    InflightOperationListener(@Nonnull MirrorOperationDecorator decorator, @Nonnull RequestReplyTopicSettings settings, @Nonnull ScheduledExecutorService scheduledExecutorService) {
        this(Clock.systemUTC(), decorator, settings, scheduledExecutorService);
    }

    public void onMessage(@Nonnull MessageEvent<TopicResponse<R>> event) {
        CorrelationId correlationId = ((TopicResponse)event.getMessage()).getCorrelationId();
        this.inFlightOperations.compute(correlationId, (id, op) -> {
            if (op == null) {
                log.warn("[{}] Received unexpected response: {} from: {}", new Object[]{correlationId, event.getMessage(), event.getSource()});
                return null;
            }
            log.trace("[{}] Received response: {}, from: {}", new Object[]{correlationId, event.getMessage(), event.getSource()});
            op.addResult(event);
            if (op.isComplete()) {
                return null;
            }
            return op;
        });
        int maximumInflightOperations = this.settings.getMaximumInflightOperations();
        int hysteresis = this.inFlightOperations.size() - maximumInflightOperations;
        if (hysteresis > 0) {
            log.warn("[{}] Current inFlightOperations: {} greater than capacity: {} removing: {} oldest operations", new Object[]{correlationId, this.inFlightOperations.size(), maximumInflightOperations, hysteresis});
            this.removeOldestOperations(hysteresis);
        }
    }

    void addOperation(CorrelationId correlationId, OperationCallback<R> callback, Set<NodeVmId> expectedRespondingNodes) {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(expectedRespondingNodes, "expectedRespondingNodes");
        log.trace("[{}] new operation added, expectedRespondingNodes: {}", (Object)correlationId, expectedRespondingNodes);
        this.inFlightOperations.computeIfAbsent(correlationId, id -> {
            this.scheduleTimeout((CorrelationId)id);
            TopicOperationCallback decoratedCallback = this.decorator.decorateCallback(callback, this.settings);
            return new InflightOperation(expectedRespondingNodes, decoratedCallback, this.clock, (CorrelationId)id);
        });
    }

    @Nonnull
    @VisibleForTesting
    ConcurrentHashMap<CorrelationId, InflightOperation<R>> getInFlightOperations() {
        return this.inFlightOperations;
    }

    void shutdown() {
        this.inFlightOperations.forEach((correlationId, operation) -> {
            operation.markEvicted();
            this.inFlightOperations.remove(correlationId);
        });
    }

    void updateClusterMembership(@Nonnull Set<NodeVmId> currentNodes) {
        Objects.requireNonNull(currentNodes, "currentNodes");
        this.inFlightOperations.forEach((id, o) -> {
            o.updateAnticipatedResponders(currentNodes);
            if (o.isComplete()) {
                this.inFlightOperations.remove(id);
            }
        });
    }

    private void removeOldestOperations(int operationsToRemove) {
        this.inFlightOperations.entrySet().stream().sorted(Comparator.comparing(o -> ((InflightOperation)o.getValue()).getStartTime())).limit(operationsToRemove).forEach(o -> {
            ((InflightOperation)o.getValue()).markEvicted();
            this.inFlightOperations.remove(o.getKey());
        });
    }

    private void scheduleTimeout(CorrelationId key) {
        this.scheduledExecutorService.schedule(() -> this.inFlightOperations.computeIfPresent(key, (k, o) -> {
            o.markTimeout();
            return null;
        }), this.settings.getOperationTimeout().toMillis(), TimeUnit.MILLISECONDS);
    }
}

