/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic;

import com.atlassian.bitbucket.dmz.cluster.exception.TopicSerializationException;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.internal.mirroring.mirror.BackoffUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.LogUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.exception.NonSerializableTopicResponseException;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.ReplyTopicName;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicMessage;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.TopicOperation;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamService;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyingTopicListener<Q extends Serializable, R extends Serializable>
implements TopicListener<TopicRequest> {
    private static final Logger log = LoggerFactory.getLogger(ReplyingTopicListener.class);
    private final Duration backoff;
    private final TopicOperation<Q, R> operation;
    private final DmzMirrorFarm mirrorFarm;
    private final TopicService topicService;
    private final UpstreamService upstreamService;

    public ReplyingTopicListener(@Nonnull TopicOperation<Q, R> operation, @Nonnull TopicService topicService, @Nonnull UpstreamService upstreamService, @Nonnull DmzMirrorFarm mirrorFarm) {
        this(Duration.ofSeconds(1L), operation, mirrorFarm, topicService, upstreamService);
    }

    @VisibleForTesting
    ReplyingTopicListener(@Nonnull Duration backoff, @Nonnull TopicOperation<Q, R> operation, @Nonnull DmzMirrorFarm mirrorFarm, @Nonnull TopicService topicService, @Nonnull UpstreamService upstreamService) {
        this.backoff = backoff;
        this.mirrorFarm = Objects.requireNonNull(mirrorFarm, "mirrorFarm");
        this.topicService = Objects.requireNonNull(topicService, "topicService");
        this.operation = Objects.requireNonNull(operation, "operation");
        this.upstreamService = Objects.requireNonNull(upstreamService, "upstreamService");
    }

    public void onMessage(@Nonnull MessageEvent<TopicRequest> message) {
        Objects.requireNonNull(message, "message");
        final TopicRequest request = (TopicRequest)message.getMessage();
        log.debug("[{}] Received request: {} from: {}", new Object[]{request.getCorrelationId(), request, message.getSource().getVmId()});
        final TopicResponse.Builder response = new TopicResponse.Builder(request);
        if (this.mirrorFarm.isBootstrapped() && this.upstreamStateReady()) {
            try {
                this.operation.perform(request.getMessage(), new FutureCallback<R>(){

                    public void onFailure(@Nonnull Throwable t) {
                        log.error("Error while processing request {}", (Object)request, (Object)t);
                        response.throwable(t);
                        ReplyingTopicListener.this.publishResponse(request.getReplyTopic(), response);
                    }

                    public void onSuccess(@Nullable R result) {
                        response.result(result);
                        ReplyingTopicListener.this.publishResponse(request.getReplyTopic(), response);
                    }
                });
            }
            catch (Throwable t) {
                log.error("Error while processing request {}: {}", new Object[]{request, t.getMessage(), LogUtils.logStacktraceIfEnabled(log.isDebugEnabled(), t)});
                response.throwable(t);
                this.publishResponse(request.getReplyTopic(), response);
            }
        } else {
            log.debug("Skipping operation for {} as node is not ready for processing", (Object)request);
            this.publishResponse(request.getReplyTopic(), response.notReadyForProcessing());
        }
    }

    private boolean upstreamStateReady() {
        UpstreamServer upstreamServer = this.upstreamService.get();
        return upstreamServer != null && EnumSet.of(IntegrationState.INSTALLED, IntegrationState.UNKNOWN).contains((Object)upstreamServer.getState());
    }

    private void publishResponse(ReplyTopicName replyTopic, TopicResponse.Builder<R> responseBuilder) {
        TopicSettings topicSettings = new TopicSettings.Builder(TopicResponse.class).build();
        Duration backoff = this.backoff;
        TopicMessage response = responseBuilder.build();
        for (int i = 1; i <= 10; ++i) {
            try {
                this.topicService.getTopic(replyTopic.getName(), topicSettings).publish((Serializable)response);
                break;
            }
            catch (TopicSerializationException exception) {
                log.warn("[{}] Failed to publish response to replyTopic:{} due to serialization error, publishing error response", new Object[]{response.getCorrelationId(), replyTopic, exception.getCause()});
                if (((TopicResponse)response).getError().isPresent()) {
                    this.publishResponse(replyTopic, new TopicResponse.Builder(response).throwable(new NonSerializableTopicResponseException(((TopicResponse)response).getError().get())));
                    break;
                }
                this.publishResponse(replyTopic, new TopicResponse.Builder<Object>((TopicResponse<Object>)response).result(null).throwable(new NonSerializableTopicResponseException(exception.getCause())));
                break;
            }
            catch (Throwable t) {
                if (i == 10) {
                    log.error("[{}] Failed to publish response to replyTopic:{}  retries exhausted, giving up", new Object[]{response.getCorrelationId(), replyTopic, t});
                    continue;
                }
                log.warn("[{}] Failed to publish response to replyTopic:{} attempt {}/{} sleeping {} ms and trying again", new Object[]{response.getCorrelationId(), replyTopic, i, 10, backoff.toMillis(), LogUtils.logStacktraceIfEnabled(log.isDebugEnabled(), t)});
                try {
                    Thread.sleep(BackoffUtils.exponentialDelay(this.backoff.toMillis(), i));
                    backoff = backoff.multipliedBy(2L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
    }
}

