/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.internal.mirroring.mirror.BackoffUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.InflightOperationListener;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.ReplyTopicName;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.ReplyingTopicListener;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicMessage;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.OperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.id.CorrelationId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.id.CorrelationIdGenerator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ErrorResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.Result;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ResultVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.SingleResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.TimeoutResult;
import com.atlassian.bitbucket.topic.Topic;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestReplyTopic<Q extends Serializable, R extends Serializable> {
    private static final Logger log = LoggerFactory.getLogger(RequestReplyTopic.class);
    private final ClusterInformation clusterInformation;
    private final AtomicLong clusterNodeRemovedEvents;
    private final CorrelationIdGenerator correlationIdGenerator;
    private final InflightOperationListener<R> inflightOperationListener;
    private final int maxAttempts;
    private final String replySubscription;
    private final Topic<TopicResponse> replyTopic;
    private final ReplyTopicName replyTopicName;
    private final Topic<TopicRequest> requestTopic;
    private final String subscriptionId;
    private final Duration topicInitialRetryDelay;
    private volatile boolean active;

    public RequestReplyTopic(ClusterInformation clusterInformation, CorrelationIdGenerator correlationIdGenerator, InflightOperationListener<R> inflightOperationListener, String name, String replySubscription, Topic<TopicResponse> replyTopic, ReplyTopicName replyTopicName, ReplyingTopicListener<Q, R> replyingTopicListener, Topic<TopicRequest> requestTopic, int maxAttempts, Duration topicInitialRetryDelay) {
        this.clusterInformation = clusterInformation;
        this.correlationIdGenerator = correlationIdGenerator;
        this.inflightOperationListener = inflightOperationListener;
        this.replySubscription = replySubscription;
        this.replyTopic = replyTopic;
        this.replyTopicName = replyTopicName;
        this.requestTopic = requestTopic;
        this.topicInitialRetryDelay = topicInitialRetryDelay;
        this.maxAttempts = maxAttempts;
        this.active = true;
        this.clusterNodeRemovedEvents = new AtomicLong();
        this.subscriptionId = requestTopic.subscribe(replyingTopicListener);
        log.debug("Subscribed to replyTopic: {} for operation: {}", (Object)replyTopicName, (Object)name);
    }

    @Nonnull
    public R publish(@Nonnull Q request) {
        Objects.requireNonNull(request, "request");
        return (R)this.publish(request, SingleResult::get);
    }

    @Nonnull
    public <E> E publish(@Nonnull Q request, @Nonnull ResultVisitor<R, E> resultVisitor) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(resultVisitor, "resultVisitor");
        ResultWaitingCallback resultWaitingCallback = new ResultWaitingCallback();
        this.publishToTopic(request, new RetryingOperationCallback(this.topicInitialRetryDelay, resultWaitingCallback, this.maxAttempts, this, request));
        try {
            return resultWaitingCallback.getResult().accept(resultVisitor);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Error while waiting for result to be received for request " + String.valueOf(request), e);
        }
    }

    void unsubscribe() {
        this.active = false;
        if (!this.replyTopic.unsubscribe(this.replySubscription)) {
            log.warn("Could not unsubscribe from reply topic with subscription id: {}", (Object)this.replySubscription);
        }
        if (!this.requestTopic.unsubscribe(this.subscriptionId)) {
            log.warn("Could not unsubscribe from request topic with subscription id: {}", (Object)this.replySubscription);
        }
        this.inflightOperationListener.shutdown();
    }

    void updateClusterMembership(Set<NodeVmId> members) {
        log.debug("Updating cluster membership");
        this.clusterNodeRemovedEvents.incrementAndGet();
        this.inflightOperationListener.updateClusterMembership(members);
    }

    private TopicRequest<Serializable> buildRequest(Q request, OperationCallback<R> callback) {
        long nodeRemovedEvents = this.clusterNodeRemovedEvents.get();
        Set<NodeVmId> expectedRespondingNodes = this.clusterMembership();
        CorrelationId correlationId = this.correlationIdGenerator.generateCorrelationId();
        this.inflightOperationListener.addOperation(correlationId, callback, expectedRespondingNodes);
        if (this.clusterNodeRemovedEvents.get() > nodeRemovedEvents) {
            this.inflightOperationListener.updateClusterMembership(this.clusterMembership());
        }
        TopicMessage topicRequest = ((TopicRequest.Builder)((Object)((TopicRequest.Builder)((Object)new TopicRequest.Builder<Q>().withDefaults(request).expectedRespondingNodes(expectedRespondingNodes))).correlationId(correlationId))).replyTopic(this.replyTopicName).build();
        log.debug("[{}] Distributing request: {}", (Object)correlationId, (Object)topicRequest);
        return topicRequest;
    }

    @Nonnull
    private Set<NodeVmId> clusterMembership() {
        return this.clusterInformation.getNodes().stream().filter(ClusterNode::isFullyStarted).map(ClusterNode::getVmId).map(NodeVmId::nodeVmId).collect(Collectors.toSet());
    }

    private void publishToTopic(Q request, OperationCallback<R> callback) {
        if (!this.active) {
            throw new IllegalStateException("Attempted to send message to a topic that is not active");
        }
        this.requestTopic.publish(this.buildRequest(request, callback));
    }

    private static class ResultWaitingCallback<R extends Serializable>
    implements OperationCallback<R> {
        private final CountDownLatch countDownLatch = new CountDownLatch(1);
        private Result<R> result;

        ResultWaitingCallback() {
        }

        @Override
        public void onConflict(@Nonnull Map<R, List<NodeVmId>> results) {
            this.result = () -> results;
            this.countDownLatch.countDown();
        }

        @Override
        public void onError(final @Nonnull Map<R, List<NodeVmId>> results, final @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
            this.result = new ErrorResult<R>(){

                @Override
                @Nonnull
                public Map<Class<? extends Throwable>, List<NodeVmId>> getErrors() {
                    return errors;
                }

                @Override
                @Nonnull
                public Map<R, List<NodeVmId>> getResults() {
                    return results;
                }
            };
            this.countDownLatch.countDown();
        }

        @Override
        public void onSuccess(@Nonnull R result) {
            this.result = () -> result;
            this.countDownLatch.countDown();
        }

        @Override
        public void onTimeout(final @Nonnull Set<NodeVmId> lost, final @Nonnull Map<R, List<NodeVmId>> results, final @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
            this.result = new TimeoutResult<R>(){

                @Override
                @Nonnull
                public Map<Class<? extends Throwable>, List<NodeVmId>> getErrors() {
                    return errors;
                }

                @Override
                public Set<NodeVmId> getLost() {
                    return lost;
                }

                @Override
                public Map<R, List<NodeVmId>> getResults() {
                    return results;
                }
            };
            this.countDownLatch.countDown();
        }

        Result<R> getResult() throws InterruptedException {
            this.countDownLatch.await();
            return this.result;
        }
    }

    private static class RetryingOperationCallback<Q extends Serializable, R extends Serializable>
    implements OperationCallback<R> {
        private final OperationCallback<R> delegate;
        private final int maxAttempts;
        private final Q request;
        private final RequestReplyTopic<Q, R> requestReplyTopic;
        private final Duration initialDelay;
        private int attempt = 1;

        RetryingOperationCallback(Duration initialDelay, OperationCallback<R> delegate, int maxAttempts, RequestReplyTopic<Q, R> requestReplyTopic, Q request) {
            this.initialDelay = initialDelay;
            this.delegate = delegate;
            this.maxAttempts = maxAttempts;
            this.requestReplyTopic = requestReplyTopic;
            this.request = request;
        }

        @Override
        public void onConflict(@Nonnull Map<R, List<NodeVmId>> results) {
            if (!this.mayBeRetry()) {
                this.delegate.onConflict(results);
            }
        }

        @Override
        public void onError(@Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
            if (!this.mayBeRetry()) {
                this.delegate.onError(results, errors);
            }
        }

        @Override
        public void onSuccess(@Nonnull R result) {
            this.delegate.onSuccess(result);
        }

        @Override
        public void onTimeout(@Nonnull Set<NodeVmId> lost, @Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
            if (!this.mayBeRetry()) {
                this.delegate.onTimeout(lost, results, errors);
            }
        }

        private boolean mayBeRetry() {
            if (this.attempt++ < this.maxAttempts) {
                long delay = BackoffUtils.exponentialDelay(this.initialDelay.toMillis(), this.attempt);
                log.trace("Sleeping for {} ms before attempt {}/{} to re-publish topic for request {}", new Object[]{this.initialDelay.toMillis(), this.attempt, this.maxAttempts, this.request});
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                this.requestReplyTopic.publishToTopic(this.request, this);
                return true;
            }
            return false;
        }
    }
}

