/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.event.cluster.ClusterNodeRemovedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.InflightOperationListener;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.MirrorOperationDecorator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.ReplyTopicName;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.ReplyingTopicListener;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopicSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.id.CorrelationIdGenerator;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamService;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class RequestReplyTopicFactory
implements DisposableBean {
    @VisibleForTesting
    final ConcurrentHashMap<String, RequestReplyTopic> topics;
    private final ClusterInformation clusterInformation;
    private final CorrelationIdGenerator correlationIdGenerator;
    private final MirrorOperationDecorator decorator;
    private final DmzMirrorFarm mirrorFarm;
    private final ScheduledExecutorService scheduledExecutorService;
    private final TopicService topicService;
    private final UpstreamService upstreamService;
    private volatile boolean active;

    @Autowired
    public RequestReplyTopicFactory(ClusterService clusterService, CorrelationIdGenerator correlationIdGenerator, MirrorOperationDecorator decorator, DmzMirrorFarm mirrorFarm, ScheduledExecutorService scheduledExecutorService, @Qualifier(value="stateTransferringTopicService") TopicService topicService, UpstreamService upstreamService) {
        this.correlationIdGenerator = correlationIdGenerator;
        this.decorator = decorator;
        this.mirrorFarm = mirrorFarm;
        this.scheduledExecutorService = scheduledExecutorService;
        this.topicService = topicService;
        this.upstreamService = upstreamService;
        this.active = true;
        this.clusterInformation = clusterService.getInformation();
        this.topics = new ConcurrentHashMap();
    }

    public void destroy() {
        this.active = false;
        this.topics.forEach((key, value) -> {
            value.unsubscribe();
            this.topics.remove(key);
        });
    }

    @EventListener
    public void onClusterNodeRemovedEvent(@Nonnull ClusterNodeRemovedEvent event) {
        Objects.requireNonNull(event, "event");
        this.topics.values().forEach(requestReplyTopic -> {
            Set<NodeVmId> members = this.toNodeVmIds(event.getCurrentNodes());
            requestReplyTopic.updateClusterMembership(members);
        });
    }

    @Nonnull
    public <Q extends Serializable, R extends Serializable> RequestReplyTopic<Q, R> registerTopic(@Nonnull MirrorOperation<Q, R> operation, @Nonnull RequestReplyTopicSettings settings) {
        if (!this.active) {
            throw new IllegalStateException("Attempting to register topic during shutown");
        }
        Objects.requireNonNull(operation, "operation");
        Objects.requireNonNull(settings, "settings");
        String settingsName = settings.getName();
        return this.topics.compute(settingsName, (name, topic) -> {
            if (topic != null) {
                throw new IllegalStateException(name + " operation has already been registered");
            }
            String localNodeVmID = this.clusterInformation.getLocalNode().getVmId();
            ReplyTopicName replyTopicName = new ReplyTopicName((String)name, localNodeVmID);
            Topic replyTopic = this.topicService.getTopic(replyTopicName.getName(), new TopicSettings.Builder(TopicResponse.class).build());
            InflightOperationListener listener = new InflightOperationListener(this.decorator, settings, this.scheduledExecutorService);
            String replySubscription = replyTopic.subscribe(listener);
            Topic requestTopic = this.topicService.getTopic(name, new TopicSettings.Builder(TopicRequest.class).build());
            ReplyingTopicListener replyingTopicListener = new ReplyingTopicListener(this.decorator.decorateOperation(operation, settings), this.topicService, this.upstreamService, this.mirrorFarm);
            return new RequestReplyTopic(this.clusterInformation, this.correlationIdGenerator, listener, (String)name, replySubscription, (Topic<TopicResponse>)replyTopic, replyTopicName, replyingTopicListener, (Topic<TopicRequest>)requestTopic, settings.getTopicMaxAttempts(), settings.getTopicInitialRetryDelay());
        });
    }

    private Set<NodeVmId> toNodeVmIds(Set<ClusterNode> clusterNodes) {
        return clusterNodes.stream().filter(ClusterNode::isFullyStarted).map(ClusterNode::getVmId).map(NodeVmId::nodeVmId).collect(Collectors.toSet());
    }
}

