/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;

public class RequestReplyTopicSettings {
    private final Duration callbackTimeout;
    private final int maximumInflightOperations;
    private final String name;
    private final Duration operationInitialRetryDelay;
    private final int operationMaxAttempts;
    private final Duration operationTimeout;
    private final Duration topicInitialRetryDelay;
    private final int topicMaxAttempts;

    private RequestReplyTopicSettings(Builder builder) {
        this.name = builder.name;
        this.maximumInflightOperations = builder.maximumInflightOperations;
        this.operationTimeout = builder.operationTimeout;
        this.callbackTimeout = builder.callbackTimeout;
        this.operationMaxAttempts = builder.operationMaxAttempts;
        this.operationInitialRetryDelay = builder.operationInitialRetryDelay;
        this.topicMaxAttempts = builder.topicMaxAttempts;
        this.topicInitialRetryDelay = builder.topicInitialRetryDelay;
    }

    public Duration getCallbackTimeout() {
        return this.callbackTimeout;
    }

    public int getMaximumInflightOperations() {
        return this.maximumInflightOperations;
    }

    public String getName() {
        return this.name;
    }

    public Duration getOperationInitialRetryDelay() {
        return this.operationInitialRetryDelay;
    }

    public int getOperationMaxAttempts() {
        return this.operationMaxAttempts;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    Duration getTopicInitialRetryDelay() {
        return this.topicInitialRetryDelay;
    }

    int getTopicMaxAttempts() {
        return this.topicMaxAttempts;
    }

    public static class Builder
    extends BuilderSupport {
        private Duration callbackTimeout;
        private int maximumInflightOperations = 1;
        private String name;
        private Duration operationInitialRetryDelay;
        private int operationMaxAttempts = 1;
        private Duration operationTimeout;
        private Duration topicInitialRetryDelay;
        private int topicMaxAttempts = 1;

        @Nonnull
        public RequestReplyTopicSettings build() {
            return new RequestReplyTopicSettings(this);
        }

        @Nonnull
        public Builder callbackTimeout(@Nonnull Duration value) {
            this.callbackTimeout = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder maximumInflightOperations(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)"maximumInflightOperations must be positive");
            this.maximumInflightOperations = value;
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder operationInitialRetryDelay(@Nonnull Duration value) {
            this.operationInitialRetryDelay = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder operationMaxAttempts(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)"operationMaxAttempts must be positive");
            this.operationMaxAttempts = value;
            return this;
        }

        @Nonnull
        public Builder operationTimeout(@Nonnull Duration value) {
            this.operationTimeout = Objects.requireNonNull(value, "value");
            return this;
        }

        public Builder topicInitialRetryDelay(Duration value) {
            this.topicInitialRetryDelay = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder topicMaxAttempts(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)"topicMaxAttempts must be positive");
            this.topicMaxAttempts = value;
            return this;
        }

        @Nonnull
        public Builder withDefaults() {
            this.name = "defaultName";
            this.operationTimeout = Duration.ofMinutes(1L);
            this.callbackTimeout = Duration.ofMinutes(1L);
            this.operationMaxAttempts = 5;
            this.maximumInflightOperations = 10000;
            this.operationInitialRetryDelay = Duration.ofMillis(500L);
            this.topicMaxAttempts = 0;
            this.topicInitialRetryDelay = Duration.ofMillis(500L);
            return this;
        }
    }
}

