/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.id.CorrelationId;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public abstract class TopicMessage
implements Serializable {
    private final ImmutableSet<NodeVmId> anticipatedResponders;
    private final CorrelationId correlationId;
    private final Instant startTime;

    protected TopicMessage(@Nonnull AbstractBuilder builder) {
        this.anticipatedResponders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(builder.anticipatedResponders, "anticipatedResponders"));
        this.correlationId = builder.correlationId;
        this.startTime = builder.startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicMessage that = (TopicMessage)o;
        return this.startTime == that.startTime && com.google.common.base.Objects.equal((Object)this.correlationId, (Object)that.correlationId) && com.google.common.base.Objects.equal(this.anticipatedResponders, that.anticipatedResponders);
    }

    @Nonnull
    public CorrelationId getCorrelationId() {
        return this.correlationId;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.correlationId, this.anticipatedResponders, this.startTime});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("correlationId", (Object)this.correlationId).add("anticipatedResponders", this.anticipatedResponders).add("startTime", (Object)this.startTime).toString();
    }

    Instant getStartTime() {
        return this.startTime;
    }

    @Nonnull
    Set<NodeVmId> getAnticipatedResponders() {
        return this.anticipatedResponders;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends TopicMessage>
    extends BuilderSupport {
        private final Clock clock;
        private Set<NodeVmId> anticipatedResponders;
        private CorrelationId correlationId;
        private Instant startTime;

        AbstractBuilder(@Nonnull TopicMessage message) {
            this(message, Clock.systemUTC());
        }

        AbstractBuilder(@Nonnull Clock clock) {
            this.clock = Objects.requireNonNull(clock, "clock");
        }

        AbstractBuilder(@Nonnull TopicMessage message, @Nonnull Clock clock) {
            Objects.requireNonNull(message, "message");
            this.clock = Objects.requireNonNull(clock, "clock");
            this.correlationId = message.getCorrelationId();
            this.startTime = message.getStartTime();
            this.anticipatedResponders = message.getAnticipatedResponders();
        }

        AbstractBuilder() {
            this.clock = Clock.systemUTC();
        }

        @Nonnull
        public abstract R build();

        public B correlationId(@Nonnull CorrelationId value) {
            this.correlationId = Objects.requireNonNull(value, "value");
            return this.self();
        }

        public B expectedRespondingNodes(@Nonnull Set<NodeVmId> value) {
            this.anticipatedResponders = Objects.requireNonNull(value, "value");
            return this.self();
        }

        public B startTime(Instant value) {
            this.startTime = value;
            return this.self();
        }

        public B withDefaults() {
            this.correlationId = new CorrelationId("foobar".getBytes(Charsets.UTF_8));
            this.anticipatedResponders = new ImmutableSet.Builder().add((Object[])new NodeVmId[]{NodeVmId.nodeVmId("a"), NodeVmId.nodeVmId("b"), NodeVmId.nodeVmId("c")}).build();
            this.startTime = this.clock.instant();
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

