/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.ReplyTopicName;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicMessage;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;

public class TopicRequest<T extends Serializable>
extends TopicMessage {
    private final T message;
    private final ReplyTopicName replyTopic;

    private TopicRequest(Builder<T> builder) {
        super(builder);
        this.message = (Serializable)Objects.requireNonNull(builder.message, "message");
        this.replyTopic = Objects.requireNonNull(builder.replyTopic, "replyTopic");
    }

    @Nonnull
    public ReplyTopicName getReplyTopic() {
        return this.replyTopic;
    }

    @Nonnull
    public T getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("message", this.message).add("replyTopic", (Object)this.replyTopic).add("anticipatedResponders", this.getAnticipatedResponders().size()).toString();
    }

    public static class Builder<T extends Serializable>
    extends TopicMessage.AbstractBuilder<Builder<T>, TopicRequest<T>> {
        private T message;
        private ReplyTopicName replyTopic;

        @Override
        @Nonnull
        public TopicRequest<T> build() {
            return new TopicRequest(this);
        }

        public Builder<T> message(@Nonnull T value) {
            this.message = (Serializable)Objects.requireNonNull(value, "value");
            return this;
        }

        public Builder<T> replyTopic(@Nonnull ReplyTopicName value) {
            this.replyTopic = Objects.requireNonNull(value, "value");
            return this;
        }

        public Builder<T> withDefaults(@Nonnull T message) {
            this.message = (Serializable)Objects.requireNonNull(message, "message");
            this.replyTopic = new ReplyTopicName("reply", "topic");
            return (Builder)((Object)this.withDefaults());
        }

        @Override
        @Nonnull
        protected Builder<T> self() {
            return this;
        }
    }
}

