/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicMessage;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.TopicRequest;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.Clock;
import java.util.Objects;
import java.util.Optional;

public class TopicResponse<T extends Serializable>
extends TopicMessage {
    private final T result;
    private final Throwable throwable;
    private final boolean readyForProcessing;

    private TopicResponse(Builder<T> builder) {
        super(builder);
        this.result = builder.result;
        this.throwable = builder.throwable;
        this.readyForProcessing = builder.readyForProcessing;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopicResponse that = (TopicResponse)o;
        return com.google.common.base.Objects.equal(this.result, that.result);
    }

    @Nonnull
    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.throwable);
    }

    @Nonnull
    public Optional<T> getResult() {
        return Optional.ofNullable(this.result);
    }

    boolean notReadyForProcessing() {
        return !this.readyForProcessing;
    }

    @Override
    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{super.hashCode(), this.result});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("throwable", (Object)this.throwable).add("result", this.result).toString();
    }

    public static class Builder<T extends Serializable>
    extends TopicMessage.AbstractBuilder<Builder<T>, TopicResponse<T>> {
        private boolean readyForProcessing = true;
        private T result;
        private Throwable throwable;

        public Builder(@Nonnull TopicRequest<?> request) {
            super(request);
        }

        public Builder(@Nonnull TopicResponse<T> response) {
            super.expectedRespondingNodes(response.getAnticipatedResponders());
            super.correlationId(response.getCorrelationId());
            super.startTime(response.getStartTime());
            this.readyForProcessing = response.readyForProcessing;
            this.result = response.result;
            this.throwable = response.throwable;
        }

        public Builder() {
        }

        public Builder(@Nonnull Clock clock) {
            super(clock);
        }

        @Override
        @Nonnull
        public TopicResponse<T> build() {
            return new TopicResponse(this);
        }

        @Nonnull
        public Builder<T> result(@Nullable T value) {
            this.result = value;
            return this.self();
        }

        public Builder<T> notReadyForProcessing() {
            this.readyForProcessing = false;
            return this.self();
        }

        @Nonnull
        public Builder<T> throwable(@Nonnull Throwable value) {
            this.throwable = Objects.requireNonNull(value, "value");
            return this.self();
        }

        @Nonnull
        public Builder<T> withDefaults(@Nonnull Throwable value) {
            this.throwable = Objects.requireNonNull(value, "value");
            return (Builder)((Object)this.withDefaults());
        }

        @Nonnull
        public Builder<T> withDefaults(@Nonnull T value) {
            this.result = (Serializable)Objects.requireNonNull(value, "value");
            return (Builder)((Object)this.withDefaults());
        }

        @Override
        @Nonnull
        protected Builder<T> self() {
            return this;
        }
    }
}

