/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.OperationCallbackMetrics;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.TopicOperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.id.CorrelationId;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MetricCollectingOperationCallback<R extends Serializable>
implements TopicOperationCallback<R> {
    private final TopicOperationCallback<R> delegate;
    private final OperationCallbackMetrics metrics;

    public MetricCollectingOperationCallback(@Nonnull TopicOperationCallback<R> delegate, @Nonnull OperationCallbackMetrics metrics) {
        this.metrics = Objects.requireNonNull(metrics, "metrics");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public void onConflict(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Map<R, List<NodeVmId>> results) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(results, "results");
        this.metrics.recordConflict(responseTime);
        this.delegate.onConflict(responseTime, correlationId, results);
    }

    @Override
    public void onError(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(results, "results");
        Objects.requireNonNull(errors, "errors");
        this.metrics.recordError(responseTime);
        this.delegate.onError(responseTime, correlationId, results, errors);
    }

    @Override
    public void onSuccess(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull R reply) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(reply, "reply");
        this.metrics.recordSuccess(responseTime);
        this.delegate.onSuccess(responseTime, correlationId, reply);
    }

    @Override
    public void onTimeout(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Set<NodeVmId> lost, @Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(lost, "lost");
        Objects.requireNonNull(results, "results");
        Objects.requireNonNull(errors, "errors");
        this.metrics.recordTimeout(responseTime);
        this.delegate.onTimeout(responseTime, correlationId, lost, results, errors);
    }
}

