/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopicSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.TopicOperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.id.CorrelationId;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadedOperationCallback<R extends Serializable>
implements TopicOperationCallback<R> {
    private static final Logger log = LoggerFactory.getLogger(MultiThreadedOperationCallback.class);
    private final TopicOperationCallback<R> delegate;
    private final ListeningExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final RequestReplyTopicSettings settings;

    public MultiThreadedOperationCallback(@Nonnull ExecutorService executorService, @Nonnull ScheduledExecutorService scheduledExecutorService, @Nonnull RequestReplyTopicSettings settings, @Nonnull TopicOperationCallback<R> delegate) {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Objects.requireNonNull(executorService, "executorService"));
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService, "scheduledExecutorService");
        this.settings = Objects.requireNonNull(settings, "settings");
    }

    @Override
    public void onConflict(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Map<R, List<NodeVmId>> results) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(results, "results");
        this.submitWithTimeout(() -> this.delegate.onConflict(responseTime, correlationId, results));
    }

    @Override
    public void onError(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(results, "results");
        Objects.requireNonNull(errors, "errors");
        this.submitWithTimeout(() -> this.delegate.onError(responseTime, correlationId, results, errors));
    }

    @Override
    public void onSuccess(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull R reply) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(reply, "reply");
        this.submitWithTimeout(() -> this.delegate.onSuccess(responseTime, correlationId, (Serializable)reply));
    }

    @Override
    public void onTimeout(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Set<NodeVmId> lost, @Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(lost, "lost");
        Objects.requireNonNull(results, "results");
        Objects.requireNonNull(errors, "errors");
        this.submitWithTimeout(() -> this.delegate.onTimeout(responseTime, correlationId, lost, results, errors));
    }

    private void submitWithTimeout(Runnable r) {
        FluentFuture.from((ListenableFuture)this.executorService.submit(r)).withTimeout(this.settings.getCallbackTimeout().getSeconds(), TimeUnit.SECONDS, this.scheduledExecutorService).addCallback((FutureCallback)new FutureCallback<Object>(this){

            public void onSuccess(@Nullable Object result) {
                log.trace("Successfully executed operation callback");
            }

            public void onFailure(@Nonnull Throwable t) {
                log.error("Error executing operation callback", t);
            }
        }, (Executor)this.executorService);
    }
}

