/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.metrics.JmxHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopicSettings;
import com.atlassian.util.profiling.MetricTimer;
import com.atlassian.util.profiling.Metrics;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class OperationCallbackMetrics {
    private static final String TYPE = "distributed";
    private final MetricTimer conflictTimer;
    private final MetricTimer errorTimer;
    private final MetricTimer successTimer;
    private final MetricTimer timeoutTimer;

    public OperationCallbackMetrics(@Nonnull RequestReplyTopicSettings settings) {
        Objects.requireNonNull(settings, "settings");
        this.successTimer = Metrics.timer((String)this.metricName(settings, "success"));
        this.conflictTimer = Metrics.timer((String)this.metricName(settings, "conflict"));
        this.errorTimer = Metrics.timer((String)this.metricName(settings, "error"));
        this.timeoutTimer = Metrics.timer((String)this.metricName(settings, "timeout"));
    }

    @VisibleForTesting
    OperationCallbackMetrics(@Nonnull MetricTimer conflictTimer, @Nonnull MetricTimer errorTimer, @Nonnull MetricTimer successTimer, @Nonnull MetricTimer timeoutTimer) {
        this.conflictTimer = conflictTimer;
        this.errorTimer = errorTimer;
        this.successTimer = successTimer;
        this.timeoutTimer = timeoutTimer;
    }

    void recordConflict(Duration responseTime) {
        this.conflictTimer.update(responseTime.toMillis(), TimeUnit.MILLISECONDS);
    }

    void recordError(Duration responseTime) {
        this.errorTimer.update(responseTime.toMillis(), TimeUnit.MILLISECONDS);
    }

    void recordSuccess(Duration responseTime) {
        this.successTimer.update(responseTime.toMillis(), TimeUnit.MILLISECONDS);
    }

    void recordTimeout(Duration responseTime) {
        this.timeoutTimer.update(responseTime.toMillis(), TimeUnit.MILLISECONDS);
    }

    private String metricName(@Nonnull RequestReplyTopicSettings settings, String name) {
        return JmxHelper.timerName("operation", TYPE, settings.getName(), name);
    }
}

