/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.OperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.TopicOperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.id.CorrelationId;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TopicOperationCallbackAdapter<R extends Serializable>
implements TopicOperationCallback<R> {
    private final OperationCallback<R> delegate;

    public TopicOperationCallbackAdapter(@Nonnull OperationCallback<R> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void onConflict(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Map<R, List<NodeVmId>> results) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(results, "results");
        this.delegate.onConflict(results);
    }

    @Override
    public void onError(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(results, "results");
        Objects.requireNonNull(errors, "errors");
        this.delegate.onError(results, errors);
    }

    @Override
    public void onSuccess(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull R result) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(result, "result");
        this.delegate.onSuccess(result);
    }

    @Override
    public void onTimeout(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Set<NodeVmId> lost, @Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(lost, "lost");
        Objects.requireNonNull(results, "results");
        Objects.requireNonNull(errors, "errors");
        this.delegate.onTimeout(lost, results, errors);
    }
}

