/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.NodeVmId;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.callback.TopicOperationCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.id.CorrelationId;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicOperationCallbackLogger<R extends Serializable>
implements TopicOperationCallback<R> {
    private static final Logger log = LoggerFactory.getLogger(TopicOperationCallbackLogger.class);
    private final TopicOperationCallback<R> delegate;
    private final String name;

    public TopicOperationCallbackLogger(@Nonnull TopicOperationCallback<R> delegate, @Nonnull String name) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    public void onConflict(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Map<R, List<NodeVmId>> results) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(results, "results");
        if (log.isTraceEnabled()) {
            log.trace("[{}] Conflict for operation: {} results: {}", new Object[]{correlationId, this.name, results});
        }
        this.delegate.onConflict(responseTime, correlationId, results);
    }

    @Override
    public void onError(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(results, "results");
        Objects.requireNonNull(errors, "errors");
        if (log.isTraceEnabled()) {
            log.trace("[{}] Error for operation: {} results: {} errors: {}", new Object[]{correlationId, this.name, results, errors});
        }
        this.delegate.onError(responseTime, correlationId, results, errors);
    }

    @Override
    public void onSuccess(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull R result) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(result, "result");
        if (log.isTraceEnabled()) {
            log.trace("[{}] Success for operation: {} result: {}", new Object[]{correlationId, this.name, result});
        }
        this.delegate.onSuccess(responseTime, correlationId, result);
    }

    @Override
    public void onTimeout(@Nonnull Duration responseTime, @Nonnull CorrelationId correlationId, @Nonnull Set<NodeVmId> lost, @Nonnull Map<R, List<NodeVmId>> results, @Nonnull Map<Class<? extends Throwable>, List<NodeVmId>> errors) {
        Objects.requireNonNull(responseTime, "responseTime");
        Objects.requireNonNull(correlationId, "correlationId");
        Objects.requireNonNull(lost, "lost");
        Objects.requireNonNull(results, "results");
        Objects.requireNonNull(errors, "errors");
        if (log.isTraceEnabled()) {
            log.trace("[{}] Timeout for operation: {} lost: {} results: {} errors: {}", new Object[]{correlationId, this.name, lost, results, errors});
        }
        this.delegate.onTimeout(responseTime, correlationId, lost, results, errors);
    }
}

