/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.metrics.JmxHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.util.profiling.MetricTimer;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class MetricCollectingMirrorOperation<Q extends Serializable, R extends Serializable>
implements MirrorOperation<Q, R> {
    private static final String TYPE = "local";
    private final Clock clock;
    private final MirrorOperation<Q, R> delegate;
    private final MetricTimer errorTimer;
    private final MetricTimer successTimer;

    public MetricCollectingMirrorOperation(@Nonnull MirrorOperation<Q, R> delegate, @Nonnull String name) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.clock = Clock.systemUTC();
        this.successTimer = Metrics.timer((String)this.metricName(name, "success"));
        this.errorTimer = Metrics.timer((String)this.metricName(name, "error"));
    }

    @VisibleForTesting
    MetricCollectingMirrorOperation(MirrorOperation<Q, R> delegate, Clock clock, MetricTimer errorTimer, MetricTimer successTimer) {
        this.clock = clock;
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.successTimer = successTimer;
        this.errorTimer = errorTimer;
    }

    @Override
    @Nonnull
    public R perform(@Nonnull Q request) {
        Objects.requireNonNull(request, "request");
        Instant start = this.clock.instant();
        boolean error = false;
        try {
            R r;
            block13: {
                Ticker ignored = Timers.timer((String)TYPE).start(new String[0]);
                try {
                    r = this.delegate.perform(request);
                    if (ignored == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        error = true;
                        throw e;
                    }
                }
                ignored.close();
            }
            return r;
        }
        finally {
            Duration elapsed = Duration.between(start, this.clock.instant());
            if (error) {
                this.errorTimer.update(elapsed.toMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.successTimer.update(elapsed.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private String metricName(@Nonnull String kind, String name) {
        return JmxHelper.timerName("operation", TYPE, kind, name);
    }
}

