/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopicSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.TopicOperation;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MultiThreadedMirrorOperation<Q extends Serializable, R extends Serializable>
implements TopicOperation<Q, R> {
    private final MirrorOperation<Q, R> delegate;
    private final ListeningExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    @Nonnull
    private final RequestReplyTopicSettings settings;

    public MultiThreadedMirrorOperation(@Nonnull ExecutorService executorService, @Nonnull ScheduledExecutorService scheduledExecutorService, @Nonnull RequestReplyTopicSettings settings, @Nonnull MirrorOperation<Q, R> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
        this.scheduledExecutorService = scheduledExecutorService;
        this.settings = settings;
    }

    @Override
    public void perform(@Nonnull Q request, @Nonnull FutureCallback<R> callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        FluentFuture.from((ListenableFuture)this.executorService.submit(() -> this.delegate.perform((Serializable)request))).withTimeout(this.settings.getOperationTimeout().getSeconds(), TimeUnit.SECONDS, this.scheduledExecutorService).addCallback(callback, (Executor)this.executorService);
    }
}

