/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation;

import com.atlassian.bitbucket.internal.mirroring.mirror.BackoffUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopicSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.TopicOperation;
import com.google.common.util.concurrent.FutureCallback;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingMirrorOperation<Q extends Serializable, R extends Serializable>
implements TopicOperation<Q, R> {
    private static final Logger log = LoggerFactory.getLogger(RetryingMirrorOperation.class);
    private final TopicOperation<Q, R> delegate;
    private final ScheduledExecutorService executor;
    private final Duration initialBackoff;
    private final int maxAttempts;
    private final String topicName;

    public RetryingMirrorOperation(@Nonnull RequestReplyTopicSettings settings, @Nonnull ScheduledExecutorService executor, @Nonnull TopicOperation<Q, R> delegate) {
        this.executor = Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(settings, "settings");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.maxAttempts = settings.getOperationMaxAttempts();
        this.initialBackoff = settings.getOperationInitialRetryDelay();
        this.topicName = settings.getName();
    }

    @Override
    public void perform(@Nonnull Q request, @Nonnull FutureCallback<R> callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        this.delegate.perform(request, new RetryingCallback(this, callback, request, this.initialBackoff.toMillis()));
    }

    private boolean maybeRetry(RetryingRequestWrapper<Q> request, RetryingCallback callback, Throwable t) {
        int attempt = request.getAttempt();
        request.incrementAttempt();
        if (attempt < this.maxAttempts) {
            long nextAttemptDelay = request.getNextAttemptDelay();
            log.warn("MirrorOperation: {} failed attempt {}/{} for request: {} waiting {} ms before retrying", new Object[]{this.topicName, attempt, this.maxAttempts, request.getRequest(), nextAttemptDelay});
            this.executor.schedule(() -> this.delegate.perform((Serializable)request.getRequest(), callback), nextAttemptDelay, TimeUnit.MILLISECONDS);
            return true;
        }
        log.error("MirrorOperation: {} failed attempt {}/{} for request: {}; giving up", new Object[]{this.topicName, attempt, this.maxAttempts, request.getRequest(), t});
        return false;
    }

    private class RetryingCallback
    implements FutureCallback<R> {
        private final FutureCallback<R> callback;
        private final RetryingRequestWrapper<Q> request;
        final /* synthetic */ RetryingMirrorOperation this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public RetryingCallback(FutureCallback<R> request, Q initialBackoff, long l2) {
            void callback;
            this.this$0 = (RetryingMirrorOperation)l;
            this.callback = callback;
            this.request = new RetryingRequestWrapper(request, (long)initialBackoff);
        }

        public void onFailure(@Nonnull Throwable t) {
            if (!this.this$0.maybeRetry(this.request, this, t)) {
                this.callback.onFailure(t);
            }
        }

        public void onSuccess(@Nullable R result) {
            log.trace("MirrorOperation: {} success on attempt {}/{} for request: {}", new Object[]{this.this$0.topicName, this.request.getAttempt(), this.this$0.maxAttempts, this.request.getRequest()});
            this.callback.onSuccess(result);
        }
    }

    private static class RetryingRequestWrapper<Q> {
        private final long initialBackoff;
        private final Q request;
        private int attempt = 1;

        public RetryingRequestWrapper(Q request, long initialBackoff) {
            this.request = request;
            this.initialBackoff = initialBackoff;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public long getNextAttemptDelay() {
            return BackoffUtils.exponentialDelay(this.initialBackoff, this.attempt);
        }

        public Q getRequest() {
            return this.request;
        }

        public void incrementAttempt() {
            ++this.attempt;
        }
    }
}

