/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.zdu;

import com.atlassian.bitbucket.dmz.zdu.DmzRollingUpgradeService;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.zdu.RollingUpgradeState;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.zdu.IllegalRollingUpgradeStateException;
import com.atlassian.event.api.EventListener;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorRollingUpgradeService {
    private static final Logger log = LoggerFactory.getLogger(MirrorRollingUpgradeService.class);
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final DmzRollingUpgradeService rollingUpgradeService;
    private final RequestReplyTopic<Boolean, RollingUpgradeState> topic;

    @Autowired
    public MirrorRollingUpgradeService(DmzRollingUpgradeService rollingUpgradeService, PermissionValidationService permissionValidationService, RequestReplyTopic<Boolean, RollingUpgradeState> topic, I18nService i18nService) {
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.rollingUpgradeService = rollingUpgradeService;
        this.topic = topic;
    }

    @Nonnull
    public RollingUpgradeState disableUpgradeMode() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        if (this.rollingUpgradeService.isClusterStable()) {
            return this.enableUpgradeModeOnAllNodes(false);
        }
        throw new IllegalRollingUpgradeStateException(this.i18nService.createKeyedMessage("bitbucket.mirroring.zdu.invalid.upgrade.mode.disable", new Object[0]));
    }

    @Nonnull
    public RollingUpgradeState enableUpgradeMode() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        return this.enableUpgradeModeOnAllNodes(true);
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent ignored) {
        this.reconcileUpgradeMode();
    }

    private RollingUpgradeState enableUpgradeModeOnAllNodes(boolean enabled) {
        return this.topic.publish(enabled);
    }

    private void reconcileUpgradeMode() {
        if (this.rollingUpgradeService.isClusterStable()) {
            return;
        }
        log.warn("Cluster contains nodes with different versions; enabling upgrade mode to reconcile cluster state. You may have unexpected cluster state");
        this.enableUpgradeModeOnAllNodes(true);
    }
}

