/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.zdu;

import com.atlassian.bitbucket.dmz.zdu.DmzRollingUpgradeService;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.zdu.RollingUpgradeState;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.sal.api.ApplicationProperties;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RollingUpgradeOperation
implements MirrorOperation<Boolean, RollingUpgradeState> {
    private final ApplicationProperties applicationProperties;
    private final DmzRollingUpgradeService rollingUpgradeService;
    private final SecurityService securityService;

    @Autowired
    public RollingUpgradeOperation(ApplicationProperties applicationProperties, DmzRollingUpgradeService rollingUpgradeService, SecurityService securityService) {
        this.applicationProperties = applicationProperties;
        this.rollingUpgradeService = rollingUpgradeService;
        this.securityService = securityService;
    }

    @Override
    @Nonnull
    public RollingUpgradeState perform(@Nonnull Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled");
        if (enabled.booleanValue()) {
            return (RollingUpgradeState)this.securityService.withPermission(Permission.SYS_ADMIN, "Enable upgrade mode on mirror farm node").call(() -> {
                this.rollingUpgradeService.enableUpgradeMode();
                return new RollingUpgradeState.Builder().enabled(this.rollingUpgradeService.getOriginalVersion().map(Version::toString).orElseThrow(() -> new IllegalStateException("Original version is not found after the upgrade mode is enabled")), this.rollingUpgradeService.isUpgradeModeEnabled()).build();
            });
        }
        return (RollingUpgradeState)this.securityService.withPermission(Permission.SYS_ADMIN, "Disable upgrade mode on mirror farm node").call(() -> {
            this.rollingUpgradeService.disableUpgradeMode();
            return new RollingUpgradeState.Builder().enabled(new Version(this.applicationProperties.getVersion()), this.rollingUpgradeService.isUpgradeModeEnabled()).build();
        });
    }
}

