/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.farm.zdu;

import com.atlassian.bitbucket.util.Version;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;

public class RollingUpgradeState
implements Serializable {
    private final boolean enabled;
    private final String version;

    private RollingUpgradeState(Builder builder) {
        this.enabled = builder.enabled;
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollingUpgradeState that = (RollingUpgradeState)o;
        return this.enabled == that.enabled && Objects.equals(this.version, that.version);
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.version);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder {
        private boolean enabled;
        private String version;

        public RollingUpgradeState build() {
            return new RollingUpgradeState(this);
        }

        public Builder enabled(@Nonnull String version, boolean enabled) {
            this.version = Objects.requireNonNull(version, "version");
            this.enabled = enabled;
            return this;
        }

        public Builder enabled(@Nonnull Version version, boolean enabled) {
            this.version = Objects.requireNonNull(version, "version").toString();
            this.enabled = enabled;
            return this;
        }
    }
}

