/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.fragments;

import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.UpstreamValidator;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.util.RequestUtils;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorSetupFragment
implements ContextualFormFragment {
    private static final Logger log = LoggerFactory.getLogger(MirrorSetupFragment.class);
    private static final String FRAGMENT_KEY = "com.atlassian.bitbucket.server.bitbucket-mirroring-mirror:mirror-setup-fragments";
    private static final String CONFIG_TEMPLATE = "bitbucketPluginMirroringMirror.internal.fragment.setup.setup.upstreamConfig";
    private static final String TEMPLATE_KEY_FORM = "form";
    private static final String TEMPLATE_KEY_FIELD_ERRORS = "fieldErrors";
    private static final String FIELD_UPSTREAM_URL = "upstreamUrl";
    private final ApplicationPropertiesService propertiesService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final InternalUpstreamService upstreamService;
    private final UpstreamValidator upstreamValidator;
    private final Validator validator;

    public MirrorSetupFragment(ApplicationPropertiesService propertiesService, InternalUpstreamService upstreamService, SoyTemplateRenderer soyTemplateRenderer, UpstreamValidator upstreamValidator, Validator validator) {
        this.propertiesService = propertiesService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.upstreamService = upstreamService;
        this.upstreamValidator = upstreamValidator;
        this.validator = validator;
    }

    public void doView(Appendable appendable, Map<String, Object> context) throws IOException {
        String pluginProperty = this.propertiesService.getPluginProperty("plugin.mirroring.upstream.url", null);
        MirrorConfigForm configForm = MirrorConfigForm.parse(pluginProperty);
        appendable.append(this.soyTemplateRenderer.render(FRAGMENT_KEY, CONFIG_TEMPLATE, this.renderContext(configForm)));
    }

    public void validate(Map<String, String[]> requestParams, ValidationErrors errors, Map<String, Object> context) {
        MirrorConfigForm configForm = MirrorConfigForm.parse(requestParams);
        Set violations = this.validator.validate((Object)configForm, new Class[0]);
        if (!violations.isEmpty()) {
            for (ConstraintViolation violation : violations) {
                errors.addFieldError(violation.getPropertyPath().toString(), violation.getMessage());
            }
        } else {
            this.upstreamValidator.validate(configForm.getUpstreamUrl()).ifPresent(keyedMessage -> errors.addFieldError(FIELD_UPSTREAM_URL, keyedMessage.getLocalisedMessage()));
        }
    }

    public void doError(Appendable appendable, Map<String, String[]> requestParams, Map<String, Collection<String>> fieldErrors, Map<String, Object> context) throws IOException {
        MirrorConfigForm configForm = MirrorConfigForm.parse(requestParams);
        appendable.append(this.soyTemplateRenderer.render(FRAGMENT_KEY, CONFIG_TEMPLATE, this.renderContext(configForm, fieldErrors)));
    }

    public void execute(Map<String, String[]> requestParams, Map<String, Object> context) {
        MirrorConfigForm configForm = MirrorConfigForm.parse(requestParams);
        this.upstreamService.create(configForm.getUpstreamUrl());
        try {
            this.upstreamService.register();
        }
        catch (RuntimeException e) {
            log.debug("Failed to register upstream in setup wizard.", (Throwable)e);
        }
    }

    private ImmutableMap<String, Object> renderContext(MirrorConfigForm configForm) {
        return this.renderContext(configForm, (Map<String, Collection<String>>)ImmutableMap.of());
    }

    private ImmutableMap<String, Object> renderContext(MirrorConfigForm configForm, Map<String, Collection<String>> fieldErrors) {
        return ImmutableMap.of((Object)TEMPLATE_KEY_FORM, (Object)configForm, (Object)TEMPLATE_KEY_FIELD_ERRORS, fieldErrors);
    }

    public static class MirrorConfigForm {
        private static final String PARAM_UPSTREAM_URL = "upstreamUrl";
        private final String upstreamUrl;

        private MirrorConfigForm(String upstreamUrl) {
            this.upstreamUrl = StringUtils.stripToNull((String)upstreamUrl);
        }

        public String getUpstreamUrl() {
            return this.upstreamUrl;
        }

        private static MirrorConfigForm parse(String url) {
            return new MirrorConfigForm(url);
        }

        private static MirrorConfigForm parse(Map<String, String[]> params) {
            String upstreamUrl = MirrorConfigForm.getParamValue("upstreamUrl", params);
            return MirrorConfigForm.parse(upstreamUrl);
        }

        private static String getParamValue(String paramName, Map<String, String[]> requestParams) {
            return RequestUtils.getParamValue((String)paramName, requestParams);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MirrorConfigForm that = (MirrorConfigForm)o;
            return Objects.equals(this.upstreamUrl, that.upstreamUrl);
        }

        public int hashCode() {
            return Objects.hash(this.upstreamUrl);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("upstreamUrl", (Object)this.upstreamUrl).toString();
        }
    }
}

