/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.handshake;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamInstallationParameters;
import com.atlassian.bitbucket.internal.mirroring.mirror.handshake.HandshakeChallengeFailedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.handshake.HandshakeChallengeService;
import com.atlassian.bitbucket.mirroring.mirror.MirrorInstalledUpstreamEvent;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.util.ValueWrapper;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handshakeChallengeService")
public class DefaultHandshakeChallengeService
implements HandshakeChallengeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultHandshakeChallengeService.class);
    private static final String CACHE_NAME = DefaultHandshakeChallengeService.class.getName();
    private static final String CACHE_NAME_BLACKLIST = CACHE_NAME + ".blacklist";
    private static final String CACHE_NAME_TRUSTED = CACHE_NAME + ".trusted";
    private static final int MAX_BLACKLIST_CACHE_SIZE = 100;
    private final Cache<String, Boolean> blacklistCache;
    private final I18nService i18nService;
    private final AtomicReference<InternalUpstreamServer> installedUpstreamServer;
    private final CachedReference<ValueWrapper<String>> trustedCache;
    private final InternalUpstreamService upstreamService;

    @Autowired
    public DefaultHandshakeChallengeService(CacheFactory cacheFactory, I18nService i18nService, InternalUpstreamService upstreamService) {
        this.i18nService = i18nService;
        this.upstreamService = upstreamService;
        this.installedUpstreamServer = new AtomicReference();
        this.blacklistCache = cacheFactory.getCache(CACHE_NAME_BLACKLIST, null, new CacheSettingsBuilder().local().maxEntries(100).build());
        this.trustedCache = cacheFactory.getCachedReference(CACHE_NAME_TRUSTED, this::trustedCacheLoader, new CacheSettingsBuilder().local().build());
    }

    @Override
    public void challenge(@Nonnull String handshakeId) throws HandshakeChallengeFailedException {
        ValueWrapper cachedHandshakeId;
        Objects.requireNonNull(handshakeId, "handshakeId");
        if (this.blacklistCache.containsKey((Object)handshakeId)) {
            log.warn("handshakeId '{}' is blacklisted, challenge failed", (Object)handshakeId);
            this.handshakeFailed();
        }
        if (Objects.equals((cachedHandshakeId = (ValueWrapper)this.trustedCache.get()).get(), handshakeId)) {
            log.trace("handshakeId '{}' is trusted, request valid", (Object)handshakeId);
            return;
        }
        this.upstreamService.getUpstreamHandshakeId().filter(handshakeId::equals).ifPresentOrElse(ignored -> {
            log.debug("Confirmed from upstream that handshakeId '{}' is valid, trusting handshake ID", (Object)handshakeId);
            UpstreamInstallationParameters.Builder updatedParams = UpstreamInstallationParameters.builder();
            InternalUpstreamServer localUpstream = this.upstreamService.getUpstreamOrFail();
            updatedParams.handshakeId(handshakeId);
            localUpstream.getIssuerId().ifPresent(updatedParams::issuerId);
            localUpstream.getSharedSecret().ifPresent(updatedParams::secret);
            InternalUpstreamServer updatedServer = this.upstreamService.overrideUpstreamInstallationParameters(updatedParams.build());
            this.installedUpstreamServer.set(updatedServer);
            this.trustedCache.reset();
        }, () -> {
            log.warn("handshakeId '{}' is not from upstream, adding to blacklist", (Object)handshakeId);
            this.blacklistCache.put((Object)handshakeId, (Object)true);
            this.handshakeFailed();
        });
    }

    @EventListener
    public void onInstalled(MirrorInstalledUpstreamEvent event) {
        UpstreamServer upstreamServer = event.getUpstream();
        if (upstreamServer instanceof InternalUpstreamServer) {
            InternalUpstreamServer upstreamServer2 = (InternalUpstreamServer)upstreamServer;
            this.installedUpstreamServer.set(upstreamServer2);
        }
        this.trustedCache.get();
    }

    private void handshakeFailed() {
        throw new HandshakeChallengeFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.handshake.challenge.failed", new Object[0]));
    }

    private ValueWrapper<String> trustedCacheLoader() {
        InternalUpstreamServer upstreamServer = this.installedUpstreamServer.get();
        if (this.installedUpstreamServer.get() == null) {
            upstreamServer = this.upstreamService.getUpstreamOrFail();
        }
        return new ValueWrapper((Serializable)((Object)((String)upstreamServer.getHandshakeId().orElse(null))));
    }
}

