/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.jwt;

import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.HttpUriRequestHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtSignedRequestFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.MirrorJwtTokenHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringUrl;
import com.atlassian.httpclient.api.EntityBuilder;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultJwtSignedRequestFactory
implements JwtSignedRequestFactory {
    private final HttpClient httpClient;
    private final MirrorJwtTokenHelper mirrorJwtTokenHelper;

    @Autowired
    public DefaultJwtSignedRequestFactory(HttpClient httpClient, MirrorJwtTokenHelper mirrorJwtTokenHelper) {
        this.httpClient = httpClient;
        this.mirrorJwtTokenHelper = mirrorJwtTokenHelper;
    }

    @Override
    @Nonnull
    public Request.Builder newRequest(@Nonnull MirroringUrl mirroringUrl) {
        return new JwtSafeRequestBuilder(this.httpClient.newRequest(), mirroringUrl);
    }

    private class JwtSafeRequestBuilder
    implements Request.Builder {
        private final Map<String, String[]> parameters;
        private final String relativeUrl;
        private Request.Builder delegate;

        private JwtSafeRequestBuilder(Request.Builder delegate, MirroringUrl mirroringUrl) {
            this.delegate = delegate;
            URI uri = URI.create(mirroringUrl.getAbsolute());
            delegate.setUri(uri);
            this.parameters = HttpUriRequestHelper.extractParameters(uri);
            this.relativeUrl = mirroringUrl.getRelative();
        }

        public Request.Builder setUri(URI uri) {
            throw new UnsupportedOperationException("URI can only be set once");
        }

        public Request.Builder setAccept(String accept) {
            this.delegate = this.delegate.setAccept(accept);
            return this;
        }

        public Request.Builder setCacheDisabled() {
            this.delegate = this.delegate.setCacheDisabled();
            return this;
        }

        public Request.Builder setAttribute(String name, String value) {
            this.delegate = this.delegate.setAttribute(name, value);
            return this;
        }

        public Request.Builder setAttributes(Map<String, String> properties) {
            this.delegate = this.delegate.setAttributes(properties);
            return this;
        }

        public Request.Builder setContentLength(long contentLength) {
            this.delegate = this.delegate.setContentLength(contentLength);
            return this;
        }

        public Request.Builder setEntity(EntityBuilder entityBuilder) {
            this.delegate = this.delegate.setEntity(entityBuilder);
            return this;
        }

        public Request.Builder setHeader(String name, String value) {
            this.delegate = this.delegate.setHeader(name, value);
            return this;
        }

        public ResponsePromise get() {
            this.injectJwtToken(Request.Method.GET);
            return this.delegate.get();
        }

        public ResponsePromise post() {
            this.injectJwtToken(Request.Method.POST);
            return this.delegate.post();
        }

        public ResponsePromise put() {
            this.injectJwtToken(Request.Method.PUT);
            return this.delegate.put();
        }

        public ResponsePromise delete() {
            this.injectJwtToken(Request.Method.DELETE);
            return this.delegate.delete();
        }

        public ResponsePromise options() {
            this.injectJwtToken(Request.Method.OPTIONS);
            return this.delegate.options();
        }

        public ResponsePromise head() {
            this.injectJwtToken(Request.Method.HEAD);
            return this.delegate.head();
        }

        public ResponsePromise trace() {
            this.injectJwtToken(Request.Method.TRACE);
            return this.delegate.trace();
        }

        public ResponsePromise execute(Request.Method method) {
            this.injectJwtToken(method);
            return this.delegate.execute(method);
        }

        public Request.Builder setHeaders(Map<String, String> headers) {
            this.delegate = (Request.Builder)this.delegate.setHeaders(headers);
            return this;
        }

        public Request.Builder setEntity(String entity) {
            this.delegate = (Request.Builder)this.delegate.setEntity(entity);
            return this;
        }

        public Request.Builder setEntityStream(InputStream entityStream) {
            this.delegate = (Request.Builder)this.delegate.setEntityStream(entityStream);
            return this;
        }

        public Request.Builder setContentCharset(String contentCharset) {
            this.delegate = (Request.Builder)this.delegate.setContentCharset(contentCharset);
            return this;
        }

        public Request.Builder setContentType(String contentType) {
            this.delegate = (Request.Builder)this.delegate.setContentType(contentType);
            return this;
        }

        public Request.Builder setEntityStream(InputStream entityStream, String charset) {
            this.delegate = (Request.Builder)this.delegate.setEntityStream(entityStream, charset);
            return this;
        }

        public Request build() {
            this.injectJwtToken(Request.Method.GET);
            return (Request)this.delegate.build();
        }

        private void injectJwtToken(Request.Method method) {
            int queryStart = this.relativeUrl.lastIndexOf(63);
            String strippedUrl = queryStart == -1 ? this.relativeUrl : this.relativeUrl.substring(0, queryStart);
            CanonicalHttpUriRequest canonical = new CanonicalHttpUriRequest(method.name(), strippedUrl, "", this.parameters);
            Optional<String> token = DefaultJwtSignedRequestFactory.this.mirrorJwtTokenHelper.generateToken(canonical);
            token.ifPresent(token1 -> this.delegate.setHeader("Authorization", "JWT " + token1));
        }
    }
}

