/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.jwt;

import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtContextUser;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Map;
import java.util.Optional;

public class JwtClaims
extends RestMapEntity {
    private static final String CONTEXT = "context";
    private static final String EXPIRATION_DATE = "exp";
    private static final String ISSUER = "iss";
    private static final String ISSUE_DATE = "iat";
    private static final String REPOSITORY = "repo";
    private static final String SUBJECT = "sub";

    @Nonnull
    public Optional<JwtContextUser> getContextUser() {
        return this.getFromContext("user").flatMap(JwtContextUser::valueOf);
    }

    @Nonnull
    public Date getExpiresDate() {
        return new Date(this.getLongProperty(EXPIRATION_DATE));
    }

    @Nonnull
    public Optional<String> getHandshakeId() {
        return this.getFromContext("handshakeId");
    }

    @Nonnull
    public String getIssuer() {
        return this.getStringProperty(ISSUER);
    }

    @Nonnull
    public Date getIsuedDate() {
        return new Date(this.getLongProperty(ISSUE_DATE));
    }

    @Nonnull
    public Optional<String> getRepository() {
        return Optional.of(this.getStringProperty(REPOSITORY));
    }

    @Nonnull
    public Optional<String> getSubject() {
        return Optional.ofNullable(this.getStringProperty(SUBJECT));
    }

    private <T> Optional<T> getFromContext(String key) {
        return Optional.ofNullable((Map)this.get(CONTEXT)).map(c -> c.get(key));
    }
}

