/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.jwt;

import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtClaims;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtClaimsUtils {
    private static final Logger log = LoggerFactory.getLogger(JwtClaimsUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    private JwtClaimsUtils() {
        throw new UnsupportedOperationException("this is a utility class and should not be instantiated");
    }

    @Nonnull
    public static Optional<JwtClaims> getJwtClaims(@Nonnull HttpServletRequest request) {
        HttpSession session;
        Objects.requireNonNull(request, "request");
        Object jwtPayloadAtt = request.getAttribute("jwt.payload");
        if (jwtPayloadAtt == null && (session = request.getSession(false)) != null) {
            jwtPayloadAtt = session.getAttribute("bitbucket.jwt.payload");
        }
        if (jwtPayloadAtt instanceof String) {
            String jsonPayload = (String)jwtPayloadAtt;
            try {
                return Optional.of((JwtClaims)((Object)mapper.readValue(jsonPayload, JwtClaims.class)));
            }
            catch (IOException e) {
                log.info("Ignoring invalid JWT claims ('{}'); error is {}", (Object)jsonPayload, (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }
}

