/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.jwt;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Optional;

public class JwtContextUser
extends RestMapEntity {
    private JwtContextUser(Map<String, Object> map) {
        super(map);
    }

    @Nonnull
    public String getDisplayName() {
        return (String)MoreObjects.firstNonNull((Object)this.getStringProperty("displayName"), (Object)this.getStringProperty("username"));
    }

    @Nullable
    public Permission getHighestPermission() {
        String permission = this.getStringProperty("highestPermission");
        if (permission != null) {
            try {
                return Permission.valueOf((String)permission.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nonnull
    public String getKey() {
        return this.getStringProperty("userKey");
    }

    @Nonnull
    public String getName() {
        return this.getStringProperty("username");
    }

    @Nonnull
    public String getSlug() {
        return this.getStringProperty("slug");
    }

    @Nonnull
    public static Optional<JwtContextUser> valueOf(Object value) {
        Map jwtContextUser;
        if (value instanceof Map && (jwtContextUser = (Map)value).containsKey("slug") && jwtContextUser.containsKey("userKey") && jwtContextUser.containsKey("username")) {
            return Optional.of(new JwtContextUser(jwtContextUser));
        }
        return Optional.empty();
    }
}

