/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.jwt;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.jwt.JwtTokenGenerationException;
import com.atlassian.bitbucket.internal.mirroring.jwt.JwtTokenHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.UpstreamServerDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.HttpUriRequestHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringUrl;
import com.atlassian.bitbucket.mirroring.mirror.MirrorInstalledUpstreamEvent;
import com.atlassian.bitbucket.mirroring.mirror.NoSuchUpstreamException;
import com.atlassian.event.api.EventListener;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Suppliers;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MirrorJwtTokenHelper {
    private static final Logger log = LoggerFactory.getLogger(MirrorJwtTokenHelper.class);
    private final MirroringConfig config;
    private final I18nService i18nService;
    private final JwtTokenHelper jwtTokenHelper;
    private final long lifetime;
    private final TransactionTemplate transactionTemplate;
    private final UpstreamServerDao upstreamServerDao;
    private volatile Supplier<InternalUpstreamServer> upstreamServer;

    MirrorJwtTokenHelper(MirroringConfig config, I18nService i18nService, JwtTokenHelper jwtTokenHelper, TransactionTemplate transactionTemplate, UpstreamServerDao upstreamServerDao) {
        this.config = config;
        this.i18nService = i18nService;
        this.jwtTokenHelper = jwtTokenHelper;
        this.transactionTemplate = transactionTemplate;
        this.upstreamServerDao = upstreamServerDao;
        this.upstreamServer = Suppliers.memoizeWithExpiration(this::getUpstreamOrFail, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.lifetime = config.getJwtLifetime().getSeconds();
    }

    @EventListener
    public void onMirrorInstalledUpstreamEvent(@Nonnull MirrorInstalledUpstreamEvent event) {
        Objects.requireNonNull(event, "event");
        this.clearCache();
    }

    public void clearCache() {
        this.upstreamServer = Suppliers.memoizeWithExpiration(this::getUpstreamOrFail, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    public Optional<String> generateToken(@Nonnull MirroringUrl mirroringUrl, @Nonnull String method) throws JwtTokenGenerationException {
        Objects.requireNonNull(mirroringUrl, "mirroringUrl");
        Objects.requireNonNull(method, "method");
        return this.generateToken(this.buildCanonicalRequest(mirroringUrl, method));
    }

    public Optional<String> generateToken(@Nonnull CanonicalHttpUriRequest canonicalHttpUriRequest) throws JwtTokenGenerationException {
        Objects.requireNonNull(canonicalHttpUriRequest, "canonicalHttpUriRequest");
        InternalUpstreamServer upstream = this.upstreamServer.get();
        String sharedSecret = upstream.getSharedSecret().orElse(null);
        if (StringUtils.isBlank((CharSequence)sharedSecret)) {
            log.warn("Shared secret not present for upstream. Request will not be signed with a JWT token");
            return Optional.empty();
        }
        try {
            return Optional.of(this.jwtTokenHelper.generateToken(canonicalHttpUriRequest, this.lifetime, this.config.getServerId(), upstream.getIssuerId().orElse(null), sharedSecret));
        }
        catch (JwtTokenGenerationException e) {
            log.warn("Could not generate jwt token, sending unsigned request", (Throwable)e);
            return Optional.empty();
        }
    }

    private CanonicalHttpUriRequest buildCanonicalRequest(MirroringUrl url, String method) {
        URI uri = URI.create(url.getAbsolute());
        Map<String, String[]> parameters = HttpUriRequestHelper.extractParameters(uri);
        String urlRelative = url.getRelative();
        int queryStart = urlRelative.lastIndexOf(63);
        String strippedUrl = queryStart == -1 ? urlRelative : urlRelative.substring(0, queryStart);
        return new CanonicalHttpUriRequest(method, strippedUrl, "", parameters);
    }

    private AoUpstreamServer getUpstreamOrFail() {
        return (AoUpstreamServer)this.transactionTemplate.execute(() -> {
            AoUpstreamServer upstream = this.upstreamServerDao.getUpstream();
            if (upstream == null) {
                throw new NoSuchUpstreamException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.not.yet.registered", new Object[0]));
            }
            return upstream;
        });
    }
}

