/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.jwt;

import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtContextUser;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.UserType;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SimpleJwtUser
implements ApplicationUser {
    private final String displayName;
    private final int id;
    private final Permission highestPermission;
    private final String slug;
    private final String username;

    public SimpleJwtUser(JwtContextUser user) {
        this.displayName = Objects.requireNonNull(user.getDisplayName(), "displayName");
        this.highestPermission = user.getHighestPermission();
        this.slug = Objects.requireNonNull(user.getSlug(), "slug");
        this.username = Objects.requireNonNull(user.getName(), "username");
        this.id = StringUtils.isNumeric((CharSequence)Objects.requireNonNull(user.getKey(), "userKey")) ? Integer.parseInt(user.getKey()) : -1;
    }

    public <T> T accept(@Nonnull ApplicationUserVisitor<T> visitor) {
        return (T)visitor.visit((ApplicationUser)this);
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return null;
    }

    public Permission getHighestPermission() {
        return this.highestPermission;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.username;
    }

    @Nonnull
    public String getSlug() {
        return this.slug;
    }

    @Nonnull
    public UserType getType() {
        return UserType.NORMAL;
    }

    public boolean isActive() {
        return true;
    }
}

