/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.mdc;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.MDC;

public class StateGeneratingJobRunner
implements JobRunner {
    private final JobRunner delegate;
    private final ClusterService clusterService;
    private final AtomicLong counter;

    public StateGeneratingJobRunner(@Nonnull ClusterService clusterService, @Nonnull JobRunner delegate) {
        this.clusterService = Objects.requireNonNull(clusterService, "clusterService");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.counter = new AtomicLong(0L);
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        MDC.put((String)"a-request-id", (String)this.generateRequestId(request));
        try {
            JobRunnerResponse jobRunnerResponse = this.delegate.runJob(request);
            return jobRunnerResponse;
        }
        finally {
            MDC.clear();
        }
    }

    private static int getMinuteOfDay() {
        LocalDateTime now = LocalDateTime.now();
        return now.getHour() * 60 + now.getMinute();
    }

    private static String hashNodeId(String clusterNodeId) {
        CRC32 crc = new CRC32();
        crc.update(DigestUtils.sha1((String)clusterNodeId));
        return Long.toString(crc.getValue(), 36).toUpperCase(Locale.US);
    }

    private String generateRequestId(JobRunnerRequest request) {
        long count = this.counter.incrementAndGet();
        return (this.clusterService.isClustered() ? "*" : "@") + StateGeneratingJobRunner.hashNodeId(this.clusterService.getNodeId()) + "x" + StateGeneratingJobRunner.getMinuteOfDay() + "x" + request.getJobId().hashCode() + "x" + count;
    }
}

