/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.mdc;

import com.atlassian.bitbucket.internal.mirroring.mirror.mdc.MdcState;
import com.atlassian.bitbucket.internal.mirroring.mirror.mdc.StateTransferringTopicListener;
import com.atlassian.bitbucket.internal.mirroring.mirror.mdc.StatefulObject;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicSettings;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;

class StateTransferringTopic<T extends Serializable>
implements Topic<T> {
    private final Topic<StatefulObject<T>> delegateTopic;
    private final TopicSettings<T> topicSettings;

    StateTransferringTopic(@Nonnull Topic<StatefulObject<T>> delegateTopic, TopicSettings<T> topicSettings) {
        this.delegateTopic = Objects.requireNonNull(delegateTopic, "delegateTopic");
        this.topicSettings = topicSettings;
    }

    @Nonnull
    public TopicSettings<T> getSettings() {
        return this.topicSettings;
    }

    public void publish(@Nonnull T message) {
        this.delegateTopic.publish(new StatefulObject<T>(message, new MdcState()));
    }

    @Nonnull
    public String subscribe(@Nonnull TopicListener<T> listener) {
        return this.delegateTopic.subscribe(new StateTransferringTopicListener<T>(listener));
    }

    public boolean unsubscribe(@Nonnull String subscriptionId) {
        return this.delegateTopic.unsubscribe(subscriptionId);
    }
}

