/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.mdc;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.internal.mirroring.mirror.mdc.MdcState;
import com.atlassian.bitbucket.internal.mirroring.mirror.mdc.StatefulObject;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.TopicListener;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

class StateTransferringTopicListener<T extends Serializable>
implements TopicListener<StatefulObject<T>> {
    private final TopicListener<T> delegate;

    StateTransferringTopicListener(@Nonnull TopicListener<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    public void onMessage(@Nonnull MessageEvent<StatefulObject<T>> message) {
        try (MdcState mdcState = ((StatefulObject)message.getMessage()).getMdcState();){
            mdcState.apply();
            this.delegate.onMessage(new TopicMessageEvent<T>(message));
        }
    }

    private static class TopicMessageEvent<T extends Serializable>
    implements MessageEvent<T> {
        private final MessageEvent<StatefulObject<T>> messageEvent;

        private TopicMessageEvent(MessageEvent<StatefulObject<T>> messageEvent) {
            this.messageEvent = messageEvent;
        }

        @Nonnull
        public T getMessage() {
            return ((StatefulObject)this.messageEvent.getMessage()).getValue();
        }

        @Nonnull
        public Date getPublishTime() {
            return this.messageEvent.getPublishTime();
        }

        @Nonnull
        public ClusterNode getSource() {
            return this.messageEvent.getSource();
        }

        @Nonnull
        public String getTopic() {
            return this.messageEvent.getTopic();
        }
    }
}

