/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.mdc;

import com.atlassian.bitbucket.internal.mirroring.mirror.mdc.MdcState;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;

class StatefulObject<T extends Serializable>
implements Serializable {
    private final MdcState mdcState;
    private final T value;

    StatefulObject(@Nonnull T value, @Nonnull MdcState mdcState) {
        this.mdcState = Objects.requireNonNull(mdcState, "mdcState");
        this.value = (Serializable)Objects.requireNonNull(value, "value");
    }

    @Nonnull
    T getValue() {
        return this.value;
    }

    @Nonnull
    MdcState getMdcState() {
        return this.mdcState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatefulObject that = (StatefulObject)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

