/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.nav;

import com.atlassian.bitbucket.internal.mirroring.MirrorType;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.DefaultRepositoryHashesUrl;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringUrl;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.PathUrlBuilder;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.RepositoryHashesUrl;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.UpstreamNavBuilder;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

class DefaultUpstreamNavBuilder
implements UpstreamNavBuilder {
    private final String baseUrl;

    DefaultUpstreamNavBuilder(UpstreamServer upstream) {
        this.baseUrl = StringUtils.stripEnd((String)upstream.getBaseUrl(), (String)"/\\");
    }

    @Override
    @Nonnull
    public MirroringUrl admin() {
        return new PathUrlBuilder(this.baseUrl, "plugins", "servlet", "admin", "mirrors");
    }

    @Override
    @Nonnull
    public MirroringUrl analyticsSettings() {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "analyticsSettings");
    }

    @Override
    @Nonnull
    public MirroringUrl capabilities() {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "capabilities");
    }

    @Override
    @Nonnull
    public MirroringUrl events(@Nonnull String mirrorId) {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "mirrorServers", mirrorId, "events");
    }

    @Override
    @Nonnull
    public MirroringUrl authenticate() {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "authenticate");
    }

    @Override
    @Nonnull
    public MirroringUrl authorize(@Nonnull MirrorType mirrorType, @Nonnull String mirrorId) {
        return this.admin().path(mirrorType.getId(), mirrorId, "authorize");
    }

    @Override
    @Nonnull
    public MirroringUrl handshake() {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "handshake");
    }

    @Override
    @Nonnull
    public MirroringUrl mirrorRequests() {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "requests");
    }

    @Override
    @Nonnull
    public MirroringUrl projectById(@Nonnull String projectId) {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "projects", Objects.requireNonNull(projectId, "projectId"));
    }

    @Override
    @Nonnull
    public MirroringUrl mirror(@Nonnull String mirrorId) {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "mirrorServers", Objects.requireNonNull(mirrorId, "mirrorId"));
    }

    @Override
    @Nonnull
    public MirroringUrl mirrors(@Nonnull PageRequest pageRequest) {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "mirrorServers").parameter("start", pageRequest.getStart()).parameter("limit", pageRequest.getLimit());
    }

    @Override
    @Nonnull
    public MirroringUrl relativeToBase(@Nonnull String path) {
        return new PathUrlBuilder(this.baseUrl, StringUtils.removeStart((String)Objects.requireNonNull(path, "path"), (String)"/").split("/"));
    }

    @Override
    @Nonnull
    public MirroringUrl repositories(@Nonnull PageRequest pageRequest) {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "repos").parameter("start", pageRequest.getStart()).parameter("limit", pageRequest.getLimit());
    }

    @Override
    @Nonnull
    public MirroringUrl repositoriesForProject(@Nonnull PageRequest pageRequest, @Nonnull String projectId) {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "projects", projectId, "repos").parameter("start", pageRequest.getStart()).parameter("limit", pageRequest.getLimit());
    }

    @Override
    @Nonnull
    public MirroringUrl repositoryById(@Nonnull String id) {
        return new PathUrlBuilder(this.baseUrl, "rest", "mirroring", "latest", "repos", id);
    }

    @Override
    @Nonnull
    public RepositoryHashesUrl repositoryHashes() {
        return new DefaultRepositoryHashesUrl(this.baseUrl);
    }

    @Override
    @Nonnull
    public MirroringUrl repositoryScmOverHttps(@Nonnull String externalProjKey, @Nonnull String externalRepoSlug) {
        return new PathUrlBuilder(new PathUrlBuilder(this.baseUrl, new String[0]), ImmutableList.builder().add((Object)"scm").add((Object)externalProjKey.toLowerCase(Locale.ROOT)).add((Object)externalRepoSlug.toLowerCase(Locale.ROOT)).build().stream());
    }

    @Override
    @Nonnull
    public MirroringUrl sshKeys() {
        return new PathUrlBuilder(this.baseUrl, "rest", "ssh", "latest", "keys");
    }

    @Override
    @Nonnull
    public MirroringUrl sshSettings() {
        return new PathUrlBuilder(this.baseUrl, "rest", "ssh", "latest", "settings");
    }
}

